/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.client.encryptor.ClientNonPersonalizedEncryptor;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.vault.PowerAuthClientVault;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.NonPersonalizedEncryptedMessage;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.http.PowerAuthRequestCanonizationUtils;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.model.CreateActivationStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.steps.v2.AbstractBaseStepV2;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationCreateCustomRequest;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationCreateResponse;
import java.io.Console;
import java.io.FileWriter;
import java.net.URLEncoder;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component(value="createActivationStepV2")
public class CreateActivationStep
extends AbstractBaseStepV2 {
    private static final PowerAuthClientActivation activation = new PowerAuthClientActivation();
    private static final KeyConvertor keyConvertor = new KeyConvertor();
    private static final PowerAuthClientKeyFactory keyFactory = new PowerAuthClientKeyFactory();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientVault vault = new PowerAuthClientVault();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();

    @Autowired
    public CreateActivationStep(StepLogger stepLogger) {
        super(PowerAuthStep.ACTIVATION_CREATE_CUSTOM, (List<PowerAuthVersion>)PowerAuthVersion.VERSION_2, stepLogger);
    }

    public CreateActivationStep() {
        this(DEFAULT_STEP_LOGGER);
    }

    @Override
    public ResultStatusObject execute(Map<String, Object> context) throws Exception {
        String message;
        CreateActivationStepModel model = new CreateActivationStepModel();
        model.fromMap(context);
        String uri = model.getUriString();
        Map<String, String> identityAttributes = model.getIdentityAttributes();
        this.stepLogger.writeItem("activation-create-custom-identity-attributes", "Identity Attributes", "Following attributes are used to authenticate user", "OK", identityAttributes);
        Map<String, Object> customAttributes = model.getCustomAttributes();
        this.stepLogger.writeItem("activation-create-custom-custom-attributes", "Custom Attributes", "Following attributes are used as custom attributes for the request", "OK", customAttributes);
        String activationOTP = "00000-00000";
        if (model.getActivationOtp() != null) {
            activationOTP = model.getActivationOtp();
        }
        this.stepLogger.writeItem("activation-create-custom-activation-otp-use", "Using activation OTP", "Following string is used as activation OTP ('00000-00000' is used by default)'", "OK", activationOTP);
        String activationIdShort = null;
        for (String key : identityAttributes.keySet()) {
            String value = identityAttributes.get(key);
            String pair = URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
            if (activationIdShort == null) {
                activationIdShort = pair;
                continue;
            }
            activationIdShort = activationIdShort + "&" + pair;
        }
        if (activationIdShort != null) {
            if ((activationIdShort = PowerAuthRequestCanonizationUtils.canonizeGetParameters(activationIdShort)) == null) {
                message = "Failed to extract parameters from query string - exiting.";
                this.stepLogger.writeError("activation-create-custom-error-query-string", message);
                this.stepLogger.writeDoneFailed("activation-create-custom-failed");
                return null;
            }
        } else {
            message = "No identity attributes were provided - exiting.";
            this.stepLogger.writeError("activation-create-custom-error-identity-attributes", message);
            this.stepLogger.writeDoneFailed("activation-create-custom-failed");
            return null;
        }
        this.stepLogger.writeItem("activation-create-custom-identity-string", "Building identity string", "Using following normalized identity string", "OK", activationIdShort);
        KeyPair clientEphemeralKeyPair = keyGenerator.generateKeyPair();
        KeyPair deviceKeyPair = activation.generateDeviceKeyPair();
        byte[] nonceDeviceBytes = activation.generateActivationNonce();
        byte[] cDevicePublicKeyBytes = activation.encryptDevicePublicKey(deviceKeyPair.getPublic(), clientEphemeralKeyPair.getPrivate(), model.getMasterPublicKey(), activationOTP, activationIdShort, nonceDeviceBytes);
        byte[] signature = activation.computeApplicationSignature(activationIdShort, nonceDeviceBytes, cDevicePublicKeyBytes, BaseEncoding.base64().decode((CharSequence)model.getApplicationKey()), BaseEncoding.base64().decode((CharSequence)model.getApplicationSecret()));
        byte[] ephemeralPublicKeyBytes = keyConvertor.convertPublicKeyToBytes(clientEphemeralKeyPair.getPublic());
        ActivationCreateRequest powerauth = new ActivationCreateRequest();
        powerauth.setActivationIdShort(activationIdShort);
        powerauth.setApplicationKey(model.getApplicationKey());
        powerauth.setActivationName(model.getActivationName());
        powerauth.setActivationNonce(BaseEncoding.base64().encode(nonceDeviceBytes));
        powerauth.setEphemeralPublicKey(BaseEncoding.base64().encode(ephemeralPublicKeyBytes));
        powerauth.setEncryptedDevicePublicKey(BaseEncoding.base64().encode(cDevicePublicKeyBytes));
        powerauth.setApplicationSignature(BaseEncoding.base64().encode(signature));
        ActivationCreateCustomRequest requestObject = new ActivationCreateCustomRequest();
        requestObject.setIdentity(identityAttributes);
        requestObject.setCustomAttributes(customAttributes);
        requestObject.setPowerauth(powerauth);
        this.stepLogger.writeItem("activation-create-custom-request-prepare", "Building activation request object", "Following activation attributes will be encrypted and sent to the server", "OK", requestObject);
        byte[] requestObjectBytes = mapper.writeValueAsBytes((Object)requestObject);
        ClientNonPersonalizedEncryptor encryptor = new ClientNonPersonalizedEncryptor(BaseEncoding.base64().decode((CharSequence)model.getApplicationKey()), model.getMasterPublicKey());
        NonPersonalizedEncryptedMessage encryptedMessage = encryptor.encrypt(requestObjectBytes);
        NonPersonalizedEncryptedPayloadModel encryptedRequestObject = new NonPersonalizedEncryptedPayloadModel();
        encryptedRequestObject.setAdHocIndex(BaseEncoding.base64().encode(encryptedMessage.getAdHocIndex()));
        encryptedRequestObject.setApplicationKey(BaseEncoding.base64().encode(encryptedMessage.getApplicationKey()));
        encryptedRequestObject.setEncryptedData(BaseEncoding.base64().encode(encryptedMessage.getEncryptedData()));
        encryptedRequestObject.setEphemeralPublicKey(BaseEncoding.base64().encode(encryptedMessage.getEphemeralPublicKey()));
        encryptedRequestObject.setMac(BaseEncoding.base64().encode(encryptedMessage.getMac()));
        encryptedRequestObject.setMacIndex(BaseEncoding.base64().encode(encryptedMessage.getMacIndex()));
        encryptedRequestObject.setNonce(BaseEncoding.base64().encode(encryptedMessage.getNonce()));
        encryptedRequestObject.setSessionIndex(BaseEncoding.base64().encode(encryptedMessage.getSessionIndex()));
        ObjectRequest body = new ObjectRequest();
        body.setRequestObject((Object)encryptedRequestObject);
        this.stepLogger.writeItem("activation-create-custom-request-encrypt", "Encrypting request object", "Following encrypted object is used for activation", "OK", body);
        try {
            ResponseEntity responseEntity;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.putAll(model.getHeaders());
            this.stepLogger.writeServerCall("activation-create-custom-request-sent", uri, "POST", requestObject, requestObjectBytes, headers);
            RestClient restClient = RestClientFactory.getRestClient();
            if (restClient == null) {
                return null;
            }
            ParameterizedTypeReference<ObjectResponse<NonPersonalizedEncryptedPayloadModel>> typeReference = new ParameterizedTypeReference<ObjectResponse<NonPersonalizedEncryptedPayloadModel>>(){};
            try {
                responseEntity = restClient.post(uri, (Object)body, null, MapUtil.toMultiValueMap(headers), (ParameterizedTypeReference)typeReference);
            }
            catch (RestClientException ex) {
                this.stepLogger.writeServerCallError("activation-create-custom-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
                this.stepLogger.writeDoneFailed("activation-create-custom-failed");
                return null;
            }
            ObjectResponse responseWrapper = Objects.requireNonNull((ObjectResponse)responseEntity.getBody());
            this.stepLogger.writeServerCallOK("activation-create-custom-response-received", responseWrapper, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
            NonPersonalizedEncryptedPayloadModel encryptedResponseObject = (NonPersonalizedEncryptedPayloadModel)responseWrapper.getResponseObject();
            encryptedMessage.setApplicationKey(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getApplicationKey()));
            encryptedMessage.setAdHocIndex(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getAdHocIndex()));
            encryptedMessage.setEphemeralPublicKey(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getEphemeralPublicKey()));
            encryptedMessage.setEncryptedData(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getEncryptedData()));
            encryptedMessage.setMac(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getMac()));
            encryptedMessage.setMacIndex(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getMacIndex()));
            encryptedMessage.setNonce(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getNonce()));
            encryptedMessage.setSessionIndex(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getSessionIndex()));
            byte[] originalResponseObjectBytes = encryptor.decrypt(encryptedMessage);
            ActivationCreateResponse responseObject = (ActivationCreateResponse)mapper.readValue(originalResponseObjectBytes, ActivationCreateResponse.class);
            this.stepLogger.writeItem("activation-create-custom-response-decrypt", "Decrypted response", "Following activation data were decrypted", "OK", responseObject);
            String activationId = responseObject.getActivationId();
            byte[] nonceServerBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getActivationNonce());
            byte[] cServerPubKeyBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedServerPublicKey());
            byte[] cServerPubKeySignatureBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedServerPublicKeySignature());
            byte[] ephemeralKeyBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEphemeralPublicKey());
            PublicKey ephemeralPublicKey = keyConvertor.convertBytesToPublicKey(ephemeralKeyBytes);
            boolean isDataSignatureValid = activation.verifyServerDataSignature(activationId, cServerPubKeyBytes, cServerPubKeySignatureBytes, model.getMasterPublicKey());
            if (isDataSignatureValid) {
                char[] password;
                PublicKey serverPublicKey = activation.decryptServerPublicKey(cServerPubKeyBytes, deviceKeyPair.getPrivate(), ephemeralPublicKey, activationOTP, activationIdShort, nonceServerBytes);
                SecretKey masterSecretKey = keyFactory.generateClientMasterSecretKey(deviceKeyPair.getPrivate(), serverPublicKey);
                SecretKey signaturePossessionSecretKey = keyFactory.generateClientSignaturePossessionKey(masterSecretKey);
                SecretKey signatureKnowledgeSecretKey = keyFactory.generateClientSignatureKnowledgeKey(masterSecretKey);
                SecretKey signatureBiometrySecretKey = keyFactory.generateClientSignatureBiometryKey(masterSecretKey);
                SecretKey transportMasterKey = keyFactory.generateServerTransportKey(masterSecretKey);
                SecretKey vaultUnlockMasterKey = keyFactory.generateServerEncryptedVaultKey(masterSecretKey);
                byte[] encryptedDevicePrivateKey = vault.encryptDevicePrivateKey(deviceKeyPair.getPrivate(), vaultUnlockMasterKey);
                if (model.getPassword() == null) {
                    Console console = System.console();
                    password = console.readPassword("Select a password to encrypt the knowledge related key: ", new Object[0]);
                } else {
                    password = model.getPassword().toCharArray();
                }
                byte[] salt = keyGenerator.generateRandomBytes(16);
                byte[] cSignatureKnowledgeSecretKey = EncryptedStorageUtil.storeSignatureKnowledgeKey(password, signatureKnowledgeSecretKey, salt, keyGenerator);
                ResultStatusObject resultStatusObject = model.getResultStatus();
                resultStatusObject.setActivationId(activationId);
                resultStatusObject.setCounter(0L);
                resultStatusObject.setCtrData(null);
                resultStatusObject.setEncryptedDevicePrivateKeyBytes(encryptedDevicePrivateKey);
                resultStatusObject.setServerPublicKeyObject(serverPublicKey);
                resultStatusObject.setSignatureBiometryKeyObject(signatureBiometrySecretKey);
                resultStatusObject.setSignatureKnowledgeKeyEncryptedBytes(cSignatureKnowledgeSecretKey);
                resultStatusObject.setSignatureKnowledgeKeySaltBytes(salt);
                resultStatusObject.setSignaturePossessionKeyObject(signaturePossessionSecretKey);
                resultStatusObject.setTransportMasterKeyObject(transportMasterKey);
                resultStatusObject.setVersion(2L);
                model.setResultStatus(resultStatusObject);
                String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatus());
                try (FileWriter file = new FileWriter(model.getStatusFileName());){
                    file.write(formatted);
                }
                HashMap<String, Object> objectMap = new HashMap<String, Object>();
                objectMap.put("activationId", activationId);
                objectMap.put("activationStatusFile", model.getStatusFileName());
                objectMap.put("activationStatusFileContent", model.getResultStatus());
                objectMap.put("deviceKeyFingerprint", activation.computeActivationFingerprint(deviceKeyPair.getPublic()));
                this.stepLogger.writeItem("activation-create-custom-activation-done", "Activation Done", "Public key exchange was successfully completed, commit the activation on server if required", "OK", objectMap);
                this.stepLogger.writeDoneOK("activation-create-custom-success");
                return model.getResultStatus();
            }
            String message2 = "Activation data signature does not match. Either someone tried to spoof your connection, or your device master key is invalid.";
            this.stepLogger.writeError("activation-create-custom-error-signature-data", message2);
            this.stepLogger.writeDoneFailed("activation-create-custom-failed");
            return null;
        }
        catch (Exception exception) {
            this.stepLogger.writeError("activation-create-custom-error-generic", exception);
            this.stepLogger.writeDoneFailed("activation-create-custom-failed");
            return null;
        }
    }
}

