/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.client.vault.PowerAuthClientVault;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureFormat;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.model.VaultUnlockStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.steps.v2.AbstractBaseStepV2;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.rest.api.model.request.v2.VaultUnlockRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.VaultUnlockResponse;
import java.io.Console;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component(value="vaultUnlockStepV2")
public class VaultUnlockStep
extends AbstractBaseStepV2 {
    private static final KeyConvertor keyConvertor = new KeyConvertor();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientSignature signature = new PowerAuthClientSignature();
    private static final PowerAuthClientKeyFactory keyFactory = new PowerAuthClientKeyFactory();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();

    @Autowired
    public VaultUnlockStep(StepLogger stepLogger) {
        super(PowerAuthStep.VAULT_UNLOCK, (List<PowerAuthVersion>)PowerAuthVersion.VERSION_2, stepLogger);
    }

    public VaultUnlockStep() {
        this(DEFAULT_STEP_LOGGER);
    }

    @Override
    public ResultStatusObject execute(Map<String, Object> context) throws Exception {
        char[] password;
        VaultUnlockStepModel model = new VaultUnlockStepModel();
        model.fromMap(context);
        String uri = model.getUriString() + "/pa/vault/unlock";
        ResultStatusObject resultStatusObject = model.getResultStatus();
        String activationId = resultStatusObject.getActivationId();
        byte[] signatureKnowledgeKeySalt = resultStatusObject.getSignatureKnowledgeKeySaltBytes();
        byte[] signatureKnowledgeKeyEncryptedBytes = resultStatusObject.getSignatureKnowledgeKeyEncryptedBytes();
        byte[] transportMasterKeyBytes = BaseEncoding.base64().decode((CharSequence)resultStatusObject.getTransportMasterKey());
        byte[] encryptedDevicePrivateKeyBytes = resultStatusObject.getEncryptedDevicePrivateKeyBytes();
        byte[] serverPublicKeyBytes = BaseEncoding.base64().decode((CharSequence)resultStatusObject.getServerPublicKey());
        if (model.getPassword() == null) {
            Console console = System.console();
            password = console.readPassword("Enter your password to unlock the knowledge related key: ", new Object[0]);
        } else {
            password = model.getPassword().toCharArray();
        }
        SecretKey signaturePossessionKey = resultStatusObject.getSignaturePossessionKeyObject();
        SecretKey signatureKnowledgeKey = EncryptedStorageUtil.getSignatureKnowledgeKey(password, signatureKnowledgeKeyEncryptedBytes, signatureKnowledgeKeySalt, keyGenerator);
        SecretKey signatureBiometryKey = resultStatusObject.getSignatureBiometryKeyObject();
        SecretKey transportMasterKey = keyConvertor.convertBytesToSharedSecretKey(transportMasterKeyBytes);
        byte[] nonceBytes = keyGenerator.generateRandomBytes(16);
        String reason = model.getReason();
        VaultUnlockRequest vaultUnlockRequest = new VaultUnlockRequest();
        vaultUnlockRequest.setReason(reason);
        ObjectRequest request = new ObjectRequest((Object)vaultUnlockRequest);
        byte[] requestBytes = RestClientConfiguration.defaultMapper().writeValueAsBytes((Object)request);
        String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/vault/unlock", (byte[])nonceBytes, (byte[])requestBytes) + "&" + model.getApplicationSecret();
        byte[] ctrData = CounterUtil.getCtrData(model.getResultStatus(), this.stepLogger);
        PowerAuthSignatureFormat signatureFormat = PowerAuthSignatureFormat.getFormatForSignatureVersion((String)model.getVersion().value());
        String signatureValue = signature.signatureForData(signatureBaseString.getBytes(StandardCharsets.UTF_8), keyFactory.keysForSignatureType(model.getSignatureType(), signaturePossessionKey, signatureKnowledgeKey, signatureBiometryKey), ctrData, signatureFormat);
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader(activationId, model.getApplicationKey(), signatureValue, model.getSignatureType().toString(), BaseEncoding.base64().encode(nonceBytes), model.getVersion().value());
        String httpAuthorizationHeader = header.buildHttpHeader();
        CounterUtil.incrementCounter(model);
        String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatus());
        try (FileWriter file = new FileWriter(model.getStatusFileName());){
            file.write(formatted);
        }
        try {
            ResponseEntity responseEntity;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Authorization", httpAuthorizationHeader);
            headers.putAll(model.getHeaders());
            this.stepLogger.writeServerCall("vault-unlock-request-sent", uri, "POST", request.getRequestObject(), null, headers);
            RestClient restClient = RestClientFactory.getRestClient();
            if (restClient == null) {
                return null;
            }
            ParameterizedTypeReference<ObjectResponse<VaultUnlockResponse>> typeReference = new ParameterizedTypeReference<ObjectResponse<VaultUnlockResponse>>(){};
            try {
                responseEntity = restClient.post(uri, (Object)requestBytes, null, MapUtil.toMultiValueMap(headers), (ParameterizedTypeReference)typeReference);
            }
            catch (RestClientException ex) {
                CounterUtil.incrementCounter(model);
                formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatus());
                try (FileWriter file = new FileWriter(model.getStatusFileName());){
                    file.write(formatted);
                }
                this.stepLogger.writeServerCallError("vault-unlock-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
                this.stepLogger.writeDoneFailed("vault-unlock-failed");
                return null;
            }
            ObjectResponse responseWrapper = Objects.requireNonNull((ObjectResponse)responseEntity.getBody());
            this.stepLogger.writeServerCallOK("vault-unlock-response-received", responseWrapper, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
            VaultUnlockResponse responseObject = (VaultUnlockResponse)responseWrapper.getResponseObject();
            byte[] encryptedVaultEncryptionKey = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedVaultEncryptionKey());
            PowerAuthClientVault vault = new PowerAuthClientVault();
            ctrData = CounterUtil.getCtrData(model.getResultStatus(), this.stepLogger);
            SecretKey vaultEncryptionKey = vault.decryptVaultEncryptionKey(encryptedVaultEncryptionKey, transportMasterKey, ctrData);
            PrivateKey devicePrivateKey = vault.decryptDevicePrivateKey(encryptedDevicePrivateKeyBytes, vaultEncryptionKey);
            PublicKey serverPublicKey = keyConvertor.convertBytesToPublicKey(serverPublicKeyBytes);
            CounterUtil.incrementCounter(model);
            formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatus());
            try (FileWriter file = new FileWriter(model.getStatusFileName());){
                file.write(formatted);
            }
            SecretKey masterSecretKey = keyFactory.generateClientMasterSecretKey(devicePrivateKey, serverPublicKey);
            SecretKey transportKeyDeduced = keyFactory.generateServerTransportKey(masterSecretKey);
            boolean equal = transportKeyDeduced.equals(transportMasterKey);
            HashMap<String, String> objectMap = new HashMap<String, String>();
            objectMap.put("activationId", activationId);
            objectMap.put("encryptedVaultEncryptionKey", BaseEncoding.base64().encode(encryptedVaultEncryptionKey));
            objectMap.put("transportMasterKey", BaseEncoding.base64().encode(keyConvertor.convertSharedSecretKeyToBytes(transportMasterKey)));
            objectMap.put("vaultEncryptionKey", BaseEncoding.base64().encode(keyConvertor.convertSharedSecretKeyToBytes(vaultEncryptionKey)));
            objectMap.put("devicePrivateKey", BaseEncoding.base64().encode(keyConvertor.convertPrivateKeyToBytes(devicePrivateKey)));
            objectMap.put("privateKeyDecryptionSuccessful", equal ? "true" : "false");
            this.stepLogger.writeItem("vault-unlock-finished", "Vault Unlocked", "Secure vault was successfully unlocked", "OK", objectMap);
            this.stepLogger.writeDoneOK("vault-unlock-success");
            return model.getResultStatus();
        }
        catch (Exception exception) {
            CounterUtil.incrementCounter(model);
            formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatus());
            try (FileWriter file = new FileWriter(model.getStatusFileName());){
                file.write(formatted);
            }
            this.stepLogger.writeError("vault-unlock-error-generic", exception);
            this.stepLogger.writeDoneFailed("vault-unlock-failed");
            return null;
        }
    }
}

