/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.generator.HashBasedCounter;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.model.BaseStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.BaseStepData;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import java.nio.ByteBuffer;

public class CounterUtil {
    public static byte[] getCtrData(BaseStepModel model, StepLogger stepLogger) {
        return CounterUtil.getCtrData(model.getResultStatus(), stepLogger);
    }

    public static byte[] getCtrData(ResultStatusObject resultStatusObject, StepLogger stepLogger) {
        byte[] ctrData = new byte[16];
        long counter = resultStatusObject.getCounter();
        int version = resultStatusObject.getVersion().intValue();
        switch (version) {
            case 2: {
                ctrData = ByteBuffer.allocate(16).putLong(8, counter).array();
                break;
            }
            case 3: {
                String ctrDataBase64 = resultStatusObject.getCtrData();
                if (ctrDataBase64.isEmpty()) break;
                ctrData = BaseEncoding.base64().decode((CharSequence)ctrDataBase64);
                break;
            }
            default: {
                if (stepLogger == null) break;
                stepLogger.writeItem("generic-error-version", "Unsupported version", "The version you specified is not supported", "ERROR", null);
            }
        }
        return ctrData;
    }

    public static void incrementCounter(BaseStepData model) {
        String ctrDataBase64;
        ResultStatusObject resultStatusObject = model.getResultStatus();
        Long counter = resultStatusObject.getCounter();
        counter = counter + 1L;
        resultStatusObject.setCounter(counter);
        int version = resultStatusObject.getVersion().intValue();
        if (version == 3 && !(ctrDataBase64 = resultStatusObject.getCtrData()).isEmpty()) {
            byte[] ctrData = BaseEncoding.base64().decode((CharSequence)ctrDataBase64);
            ctrData = new HashBasedCounter().next(ctrData);
            resultStatusObject.setCtrData(BaseEncoding.base64().encode(ctrData));
        }
    }
}

