/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.header;

import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderProvider;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.EncryptionHeaderData;

public class EncryptionHeaderProvider
implements PowerAuthHeaderProvider<EncryptionHeaderData> {
    @Override
    public void addHeader(StepContext<? extends EncryptionHeaderData, ?> stepContext) {
        EncryptionHeaderData model = stepContext.getModel();
        RequestContext requestContext = stepContext.getRequestContext();
        String activationId = model.getResultStatus().getActivationId();
        PowerAuthEncryptionHttpHeader header = new PowerAuthEncryptionHttpHeader(model.getApplicationKey(), activationId, model.getVersion().value());
        String headerValue = header.buildHttpHeader();
        requestContext.setAuthorizationHeader(headerValue);
        requestContext.setAuthorizationHeaderName("X-PowerAuth-Encryption");
        requestContext.getHttpHeaders().put("X-PowerAuth-Encryption", headerValue);
    }
}

