/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.status;

import io.getlime.security.powerauth.lib.cmd.status.ResultStatusMemoryHolder;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.model.feature.ResultStatusChangeable;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(prefix="resultstatus", name={"persistenceType"}, havingValue="memory")
@Service
public class ResultStatusMemoryService
implements ResultStatusService {
    private final ResultStatusMemoryHolder resultStatusMemoryHolder;

    @Autowired
    public ResultStatusMemoryService(ResultStatusMemoryHolder resultStatusMemoryHolder) {
        this.resultStatusMemoryHolder = resultStatusMemoryHolder;
    }

    @Override
    public void save(ResultStatusChangeable model) throws IOException {
        ResultStatusObject status = model.getResultStatus();
        this.resultStatusMemoryHolder.put(status.getActivationId(), status);
    }
}

