/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.google.common.collect.ImmutableList;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.DisabledStepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.ResponseContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.security.SimpleSecurityContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.BaseStepData;
import io.getlime.security.powerauth.lib.cmd.steps.model.feature.DryRunCapable;
import io.getlime.security.powerauth.lib.cmd.steps.model.feature.ResultStatusChangeable;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.lib.cmd.util.SecurityUtil;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.json.simple.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;

public abstract class AbstractBaseStep<M extends BaseStepData, R>
implements BaseStep {
    private final PowerAuthStep step;
    private final ImmutableList<PowerAuthVersion> supportedVersions;
    protected final ResultStatusService resultStatusService;
    protected StepLoggerFactory stepLoggerFactory;

    public AbstractBaseStep(PowerAuthStep step, List<PowerAuthVersion> supportedVersions, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        this.step = step;
        this.supportedVersions = ImmutableList.copyOf(supportedVersions);
        this.resultStatusService = resultStatusService;
        this.stepLoggerFactory = stepLoggerFactory;
    }

    public abstract StepContext<M, R> prepareStepContext(StepLogger var1, Map<String, Object> var2) throws Exception;

    protected abstract ParameterizedTypeReference<R> getResponseTypeReference();

    @Override
    public ResultStatusObject execute(Map<String, Object> context) throws Exception {
        StepLogger stepLogger = this.stepLoggerFactory.createStepLogger();
        stepLogger.start();
        JSONObject jsonObject = this.execute(stepLogger, context);
        stepLogger.close();
        if (jsonObject == null) {
            return null;
        }
        return ResultStatusObject.fromJsonObject(jsonObject);
    }

    public final JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        if (stepLogger == null) {
            stepLogger = DisabledStepLogger.INSTANCE;
        }
        stepLogger.writeItem(this.getStep().id() + "-start", this.getStep().description() + " Started", null, "OK", null);
        StepContext<M, R> stepContext = this.prepareStepContext(stepLogger, context);
        try {
            ResponseContext<R> responseContext = this.callServer(stepContext);
            if (responseContext != null) {
                stepContext.setResponseContext(responseContext);
                this.processResponse(stepContext);
                stepLogger.writeDoneOK(this.getStep().id() + "-success");
            } else if (!this.isDryRun(stepContext.getModel())) {
                stepContext.getStepLogger().writeDoneFailed(this.getStep().id() + "-failed");
            }
        }
        catch (Exception exception) {
            stepLogger.writeError(this.getStep().id() + "-error-generic", exception);
            stepLogger.writeDoneFailed(this.getStep().id() + "-failed");
            return null;
        }
        return stepContext.getModel().getResultStatusObject();
    }

    public void addEncryptedRequest(StepContext<M, R> stepContext, String applicationSecret, EciesSharedInfo1 eciesSharedInfo, byte[] data) throws Exception {
        EciesEncryptor encryptor;
        M model = stepContext.getModel();
        SimpleSecurityContext securityContext = (SimpleSecurityContext)stepContext.getSecurityContext();
        ResultStatusObject resultStatusObject = model.getResultStatus();
        if (securityContext == null) {
            encryptor = SecurityUtil.createEncryptor(applicationSecret, resultStatusObject, eciesSharedInfo);
            stepContext.setSecurityContext(SimpleSecurityContext.builder().encryptor(encryptor).build());
        } else {
            encryptor = securityContext.getEncryptor();
        }
        boolean useIv = model.getVersion().useIv();
        EciesCryptogram eciesCryptogram = encryptor.encryptRequest(data, useIv);
        EciesEncryptedRequest encryptedRequest = SecurityUtil.createEncryptedRequest(eciesCryptogram, useIv);
        stepContext.getRequestContext().setRequestObject(encryptedRequest);
    }

    public <T> T decryptResponse(StepContext<?, EciesEncryptedResponse> stepContext, Class<T> cls) throws Exception {
        SimpleSecurityContext securityContext = (SimpleSecurityContext)stepContext.getSecurityContext();
        EciesEncryptor encryptor = securityContext.getEncryptor();
        EciesEncryptedResponse encryptedResponse = stepContext.getResponseContext().getResponseBodyObject();
        byte[] decryptedBytes = SecurityUtil.decryptBytesFromResponse(encryptor, encryptedResponse);
        Object responsePayload = RestClientConfiguration.defaultMapper().readValue(decryptedBytes, cls);
        stepContext.getResponseContext().setResponsePayloadDecrypted(responsePayload);
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-response-decrypt", "Decrypted Response", "Following data were decrypted", "OK", responsePayload);
        return (T)responsePayload;
    }

    public void processResponse(StepContext<M, R> stepContext) throws Exception {
    }

    public final void processResponse(StepContext<M, R> stepContext, byte[] responseBody, Class<R> responseObjectClass) throws Exception {
        R responseBodyObject = HttpUtil.fromBytes(responseBody, responseObjectClass);
        ResponseEntity responseEntity = ResponseEntity.of(Optional.of(responseBodyObject));
        this.addResponseContext(stepContext, responseEntity);
        this.processResponse(stepContext);
    }

    protected final StepContext<M, R> buildStepContext(StepLogger stepLogger, M model, RequestContext requestContext) {
        StepContext context = new StepContext();
        context.setModel(model);
        context.setRequestContext(requestContext);
        context.setStep(this.getStep());
        context.setStepLogger(stepLogger);
        return context;
    }

    protected <RS extends ResultStatusChangeable> void incrementCounter(RS model) throws Exception {
        CounterUtil.incrementCounter(model);
        this.resultStatusService.save(model);
    }

    protected void logDryRun(StepLogger stepLogger) {
        stepLogger.writeItem(this.getStep().id() + "-dry-run", "Dry run", "The request was just dry-run, no external service call", "OK", null);
    }

    @Nullable
    private ResponseContext<R> callServer(StepContext<M, R> stepContext) throws Exception {
        ResponseEntity responseEntity;
        M model = stepContext.getModel();
        RequestContext requestContext = stepContext.getRequestContext();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        headers.putAll(requestContext.getHttpHeaders());
        if (model.getHeaders() != null && !model.getHeaders().isEmpty()) {
            headers.putAll(model.getHeaders());
        }
        byte[] requestBytes = HttpUtil.toRequestBytes(requestContext.getRequestObject());
        stepContext.getStepLogger().writeServerCall(this.step.id() + "-request-sent", requestContext.getUri(), requestContext.getHttpMethod().name(), requestContext.getRequestObject(), requestBytes, headers);
        if (this.isDryRun(model)) {
            this.logDryRun(stepContext.getStepLogger());
            stepContext.getStepLogger().writeDoneOK(this.getStep().id() + "-success");
            return null;
        }
        RestClient restClient = RestClientFactory.getRestClient();
        if (restClient == null) {
            stepContext.getStepLogger().writeError(this.step.id() + "-error-rest-client", "Unable to prepare a REST client");
            return null;
        }
        try {
            responseEntity = HttpMethod.GET.equals((Object)requestContext.getHttpMethod()) ? restClient.get(requestContext.getUri(), null, MapUtil.toMultiValueMap(headers), ParameterizedTypeReference.forType((Type)this.getResponseTypeReference().getType())) : restClient.post(requestContext.getUri(), (Object)requestBytes, null, MapUtil.toMultiValueMap(headers), ParameterizedTypeReference.forType((Type)this.getResponseTypeReference().getType()));
        }
        catch (RestClientException ex) {
            stepContext.getStepLogger().writeServerCallError(this.step.id() + "-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
            return null;
        }
        return this.addResponseContext(stepContext, responseEntity);
    }

    private ResponseContext<R> addResponseContext(StepContext<M, R> stepContext, ResponseEntity<R> responseEntity) {
        Object responseBodyObject = Objects.requireNonNull(responseEntity.getBody());
        stepContext.getStepLogger().writeServerCallOK(this.step.id() + "-response-received", responseBodyObject, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
        ResponseContext<Object> responseContext = ResponseContext.builder().responseBodyObject(responseBodyObject).responseEntity(responseEntity).build();
        stepContext.setResponseContext(responseContext);
        return responseContext;
    }

    private boolean isDryRun(M model) {
        return model instanceof DryRunCapable && ((DryRunCapable)model).isDryRun();
    }

    @Override
    public PowerAuthStep getStep() {
        return this.step;
    }

    public ImmutableList<PowerAuthVersion> getSupportedVersions() {
        return this.supportedVersions;
    }
}

