/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderFactory;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.VerifySignatureStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.SignatureHeaderData;
import io.getlime.security.powerauth.lib.cmd.util.VerifySignatureUtil;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
public class VerifySignatureStep
extends AbstractBaseStep<VerifySignatureStepModel, ObjectResponse<Map<String, Object>>> {
    ParameterizedTypeReference<ObjectResponse<Map<String, Object>>> RESPONSE_TYPE_REFERENCE = new ParameterizedTypeReference<ObjectResponse<Map<String, Object>>>(){};
    private final PowerAuthHeaderFactory powerAuthHeaderFactory;

    @Autowired
    public VerifySignatureStep(PowerAuthHeaderFactory powerAuthHeaderFactory, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.SIGNATURE_VERIFY, (List<PowerAuthVersion>)PowerAuthVersion.ALL_VERSIONS, resultStatusService, stepLoggerFactory);
        this.powerAuthHeaderFactory = powerAuthHeaderFactory;
    }

    public VerifySignatureStep() {
        this(BackwardCompatibilityConst.POWER_AUTH_HEADER_FACTORY, BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    public ParameterizedTypeReference<ObjectResponse<Map<String, Object>>> getResponseTypeReference() {
        return this.RESPONSE_TYPE_REFERENCE;
    }

    @Override
    public StepContext<VerifySignatureStepModel, ObjectResponse<Map<String, Object>>> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        VerifySignatureStepModel model = new VerifySignatureStepModel();
        model.fromMap(context);
        byte[] dataFileBytes = VerifySignatureUtil.extractRequestDataBytes(model, stepLogger);
        RequestContext requestContext = RequestContext.builder().httpMethod(HttpMethod.valueOf((String)model.getHttpMethod())).requestObject(dataFileBytes).signatureHttpMethod(model.getHttpMethod()).signatureRequestUri(model.getResourceId()).uri(model.getUriString()).build();
        StepContext<VerifySignatureStepModel, ObjectResponse<Map<String, Object>>> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        this.powerAuthHeaderFactory.getHeaderProvider(model).addHeader((StepContext<? extends SignatureHeaderData, ?>)stepContext);
        this.incrementCounter(model);
        return stepContext;
    }

    @Override
    public void logDryRun(StepLogger stepLogger) {
        stepLogger.writeItem(this.getStep().id() + "-signature-computed", "Signature computed", "Activation signature header was computed successfully", "OK", null);
    }

    @Override
    public void processResponse(StepContext<VerifySignatureStepModel, ObjectResponse<Map<String, Object>>> stepContext) throws Exception {
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-signature-verified", "Signature verified", "Activation signature was verified successfully", "OK", null);
    }
}

