/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v2;

import com.google.common.io.BaseEncoding;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.lib.model.ActivationStatusBlobInfo;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.model.ExtendedActivationStatusBlobInfo;
import io.getlime.security.powerauth.lib.cmd.steps.model.GetStatusStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.steps.v2.AbstractBaseStepV2;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationStatusResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component(value="getStatusStepV2")
public class GetStatusStep
extends AbstractBaseStepV2 {
    private static final PowerAuthClientActivation activation = new PowerAuthClientActivation();
    private static final KeyConvertor keyConvertor = new KeyConvertor();

    @Autowired
    public GetStatusStep(StepLogger stepLogger) {
        super(PowerAuthStep.ACTIVATION_STATUS, (List<PowerAuthVersion>)PowerAuthVersion.VERSION_2, stepLogger);
    }

    public GetStatusStep() {
        this(DEFAULT_STEP_LOGGER);
    }

    @Override
    public ResultStatusObject execute(Map<String, Object> context) {
        GetStatusStepModel model = new GetStatusStepModel();
        model.fromMap(context);
        String uri = model.getUriString() + "/pa/activation/status";
        ResultStatusObject resultStatusObject = model.getResultStatus();
        String activationId = resultStatusObject.getActivationId();
        String transportMasterKeyBase64 = resultStatusObject.getTransportMasterKey();
        SecretKey transportMasterKey = keyConvertor.convertBytesToSharedSecretKey(BaseEncoding.base64().decode((CharSequence)transportMasterKeyBase64));
        ActivationStatusRequest requestObject = new ActivationStatusRequest();
        requestObject.setActivationId(activationId);
        ObjectRequest body = new ObjectRequest();
        body.setRequestObject((Object)requestObject);
        try {
            ResponseEntity responseEntity;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.putAll(model.getHeaders());
            this.stepLogger.writeServerCall("activation-status-request-sent", uri, "POST", requestObject, null, headers);
            RestClient restClient = RestClientFactory.getRestClient();
            if (restClient == null) {
                return null;
            }
            ParameterizedTypeReference<ObjectResponse<ActivationStatusResponse>> typeReference = new ParameterizedTypeReference<ObjectResponse<ActivationStatusResponse>>(){};
            try {
                responseEntity = restClient.post(uri, (Object)body, null, MapUtil.toMultiValueMap(headers), (ParameterizedTypeReference)typeReference);
            }
            catch (RestClientException ex) {
                this.stepLogger.writeServerCallError("activation-status-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
                this.stepLogger.writeDoneFailed("activation-status-failed");
                return null;
            }
            ObjectResponse responseWrapper = Objects.requireNonNull((ObjectResponse)responseEntity.getBody());
            this.stepLogger.writeServerCallOK("activation-status-response-received", responseWrapper, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
            ActivationStatusResponse responseObject = (ActivationStatusResponse)responseWrapper.getResponseObject();
            byte[] cStatusBlob = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedStatusBlob());
            ActivationStatusBlobInfo statusBlobRaw = activation.getStatusFromEncryptedBlob(cStatusBlob, null, null, transportMasterKey);
            ExtendedActivationStatusBlobInfo statusBlob = ExtendedActivationStatusBlobInfo.copy(statusBlobRaw);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("activationId", activationId);
            objectMap.put("statusBlob", (Object)statusBlob);
            this.stepLogger.writeItem("activation-status-obtained", "Activation Status", "Activation status successfully obtained", "OK", objectMap);
            this.stepLogger.writeDoneOK("activation-status-success");
            return model.getResultStatus();
        }
        catch (Exception exception) {
            this.stepLogger.writeError("activation-status-error-generic", exception);
            this.stepLogger.writeDoneFailed("activation-status-failed");
            return null;
        }
    }
}

