/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import com.google.common.io.BaseEncoding;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.ActivationStatusBlobInfo;
import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.logging.model.ExtendedActivationStatusBlobInfo;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.GetStatusStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationStatusResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;

@Component(value="getStatusStepV3")
public class GetStatusStep
extends AbstractBaseStep<GetStatusStepModel, ObjectResponse<ActivationStatusResponse>> {
    public static final String ATTRIBUTE_CHALLENGE = "challenge";
    private static final ParameterizedTypeReference<ObjectResponse<ActivationStatusResponse>> RESPONSE_TYPE_REFERENCE = new ParameterizedTypeReference<ObjectResponse<ActivationStatusResponse>>(){};
    private static final PowerAuthClientActivation ACTIVATION = new PowerAuthClientActivation();
    private static final KeyGenerator KEY_GENERATOR = new KeyGenerator();

    @Autowired
    public GetStatusStep(ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.ACTIVATION_STATUS, (List<PowerAuthVersion>)PowerAuthVersion.VERSION_3, resultStatusService, stepLoggerFactory);
    }

    public GetStatusStep() {
        this(BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    protected ParameterizedTypeReference<ObjectResponse<ActivationStatusResponse>> getResponseTypeReference() {
        return RESPONSE_TYPE_REFERENCE;
    }

    @Override
    public StepContext<GetStatusStepModel, ObjectResponse<ActivationStatusResponse>> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        GetStatusStepModel model = new GetStatusStepModel();
        model.fromMap(context);
        boolean useChallenge = !model.getVersion().equals((Object)PowerAuthVersion.V3_0);
        byte[] challenge = useChallenge ? KEY_GENERATOR.generateRandomBytes(16) : null;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (challenge != null) {
            attributes.put(ATTRIBUTE_CHALLENGE, challenge);
        }
        RequestContext requestContext = RequestContext.builder().uri(model.getUriString() + "/pa/v3/activation/status").build();
        StepContext<GetStatusStepModel, ObjectResponse<ActivationStatusResponse>> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        stepContext.setAttributes(attributes);
        ActivationStatusRequest requestObject = new ActivationStatusRequest();
        requestObject.setActivationId(model.getResultStatus().getActivationId());
        requestObject.setChallenge(challenge != null ? BaseEncoding.base64().encode(challenge) : null);
        ObjectRequest body = new ObjectRequest();
        body.setRequestObject((Object)requestObject);
        requestContext.setRequestObject(body);
        return stepContext;
    }

    @Override
    public void processResponse(StepContext<GetStatusStepModel, ObjectResponse<ActivationStatusResponse>> stepContext) throws Exception {
        ResultStatusObject resultStatusObject = stepContext.getModel().getResultStatus();
        boolean useChallenge = !stepContext.getModel().getVersion().equals((Object)PowerAuthVersion.V3_0);
        ActivationStatusResponse responseObject = (ActivationStatusResponse)stepContext.getResponseContext().getResponseBodyObject().getResponseObject();
        byte[] cStatusBlob = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedStatusBlob());
        byte[] cStatusBlobNonce = useChallenge ? BaseEncoding.base64().decode((CharSequence)responseObject.getNonce()) : null;
        Map customObject = responseObject.getCustomObject();
        byte[] challenge = (byte[])stepContext.getAttributes().get(ATTRIBUTE_CHALLENGE);
        ActivationStatusBlobInfo statusBlobRaw = ACTIVATION.getStatusFromEncryptedBlob(cStatusBlob, challenge, cStatusBlobNonce, resultStatusObject.getTransportMasterKeyObject());
        ExtendedActivationStatusBlobInfo statusBlob = ExtendedActivationStatusBlobInfo.copy(statusBlobRaw);
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("activationId", resultStatusObject.getActivationId());
        objectMap.put("statusBlob", (Object)statusBlob);
        objectMap.put("customObject", customObject);
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-obtained", "Activation Status", "Activation status successfully obtained", "OK", objectMap);
    }
}

