/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderFactory;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.VerifySignatureStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.SignatureHeaderData;
import io.getlime.security.powerauth.lib.cmd.util.EncryptionUtil;
import io.getlime.security.powerauth.lib.cmd.util.VerifySignatureUtil;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
public class SignAndEncryptStep
extends AbstractBaseStep<VerifySignatureStepModel, EciesEncryptedResponse> {
    private final PowerAuthHeaderFactory powerAuthHeaderFactory;

    @Autowired
    public SignAndEncryptStep(PowerAuthHeaderFactory powerAuthHeaderFactory, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.SIGN_ENCRYPT, (List<PowerAuthVersion>)PowerAuthVersion.VERSION_3, resultStatusService, stepLoggerFactory);
        this.powerAuthHeaderFactory = powerAuthHeaderFactory;
    }

    public SignAndEncryptStep() {
        this(BackwardCompatibilityConst.POWER_AUTH_HEADER_FACTORY, BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    protected ParameterizedTypeReference<EciesEncryptedResponse> getResponseTypeReference() {
        return PowerAuthConst.RESPONSE_TYPE_REFERENCE_V3;
    }

    @Override
    public StepContext<VerifySignatureStepModel, EciesEncryptedResponse> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        VerifySignatureStepModel model = new VerifySignatureStepModel();
        model.fromMap(context);
        RequestContext requestContext = RequestContext.builder().signatureHttpMethod(model.getHttpMethod()).signatureRequestUri(model.getResourceId()).uri(model.getUriString()).build();
        StepContext<VerifySignatureStepModel, EciesEncryptedResponse> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        if (model.getHttpMethod() == null) {
            stepLogger.writeError("sign-encrypt-error-http-method", "HTTP method not specified", "Specify HTTP method to use for sending request");
            stepLogger.writeDoneFailed("sign-encrypt-failed");
            return null;
        }
        if (!HttpMethod.POST.name().equals(model.getHttpMethod().toUpperCase())) {
            stepLogger.writeError("sign-encrypt-error-http-method-invalid", "Sign and Encrypt Request Failed", "Unsupported HTTP method: " + model.getHttpMethod().toUpperCase());
            stepLogger.writeDoneFailed("sign-encrypt-failed");
            return null;
        }
        byte[] requestDataBytes = model.getData();
        if (requestDataBytes == null) {
            stepLogger.writeError("sign-encrypt-error-file", "Sign and Encrypt Request Failed", "Request data for encryption and signing is null.");
            stepLogger.writeDoneFailed("sign-encrypt-failed");
            return null;
        }
        stepLogger.writeItem(this.getStep().id() + "-request-prepare", "Preparing Request Data", "Following data will be encrypted", "OK", requestDataBytes);
        byte[] dataFileBytes = VerifySignatureUtil.extractRequestDataBytes(model, stepLogger);
        requestContext.setRequestObject(dataFileBytes);
        this.powerAuthHeaderFactory.getHeaderProvider(model).addHeader((StepContext<? extends SignatureHeaderData, ?>)stepContext);
        this.addEncryptedRequest(stepContext, model.getApplicationSecret(), EciesSharedInfo1.ACTIVATION_SCOPE_GENERIC, requestDataBytes);
        this.incrementCounter(model);
        return stepContext;
    }

    @Override
    public void processResponse(StepContext<VerifySignatureStepModel, EciesEncryptedResponse> stepContext) throws Exception {
        EncryptionUtil.processEncryptedResponse(stepContext, this.getStep().id());
    }
}

