/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.vault.PowerAuthClientVault;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderFactory;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.VaultUnlockStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.SignatureHeaderData;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.rest.api.model.request.v3.VaultUnlockRequestPayload;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.VaultUnlockResponsePayload;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;

@Component(value="vaultUnlockStepV3")
public class VaultUnlockStep
extends AbstractBaseStep<VaultUnlockStepModel, EciesEncryptedResponse> {
    private final PowerAuthHeaderFactory powerAuthHeaderFactory;
    private static final KeyConvertor KEY_CONVERTOR = new KeyConvertor();
    private static final PowerAuthClientKeyFactory KEY_FACTORY = new PowerAuthClientKeyFactory();

    @Autowired
    public VaultUnlockStep(PowerAuthHeaderFactory powerAuthHeaderFactory, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.VAULT_UNLOCK, (List<PowerAuthVersion>)PowerAuthVersion.VERSION_3, resultStatusService, stepLoggerFactory);
        this.powerAuthHeaderFactory = powerAuthHeaderFactory;
    }

    public VaultUnlockStep() {
        this(BackwardCompatibilityConst.POWER_AUTH_HEADER_FACTORY, BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    protected ParameterizedTypeReference<EciesEncryptedResponse> getResponseTypeReference() {
        return PowerAuthConst.RESPONSE_TYPE_REFERENCE_V3;
    }

    @Override
    public StepContext<VaultUnlockStepModel, EciesEncryptedResponse> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        VaultUnlockStepModel model = new VaultUnlockStepModel();
        model.fromMap(context);
        RequestContext requestContext = RequestContext.builder().signatureHttpMethod("POST").signatureRequestUri("/pa/vault/unlock").uri(model.getUriString() + "/pa/v3/vault/unlock").build();
        StepContext<VaultUnlockStepModel, EciesEncryptedResponse> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        VaultUnlockRequestPayload requestPayload = new VaultUnlockRequestPayload();
        requestPayload.setReason(model.getReason());
        byte[] requestBytesPayload = RestClientConfiguration.defaultMapper().writeValueAsBytes((Object)requestPayload);
        this.addEncryptedRequest(stepContext, model.getApplicationSecret(), EciesSharedInfo1.VAULT_UNLOCK, requestBytesPayload);
        this.powerAuthHeaderFactory.getHeaderProvider(model).addHeader((StepContext<? extends SignatureHeaderData, ?>)stepContext);
        this.incrementCounter(model);
        return stepContext;
    }

    @Override
    public void processResponse(StepContext<VaultUnlockStepModel, EciesEncryptedResponse> stepContext) throws Exception {
        VaultUnlockResponsePayload responsePayload = this.decryptResponse(stepContext, VaultUnlockResponsePayload.class);
        ResultStatusObject resultStatusObject = stepContext.getModel().getResultStatus();
        SecretKey transportMasterKey = resultStatusObject.getTransportMasterKeyObject();
        byte[] encryptedDevicePrivateKeyBytes = resultStatusObject.getEncryptedDevicePrivateKeyBytes();
        byte[] encryptedVaultEncryptionKey = BaseEncoding.base64().decode((CharSequence)responsePayload.getEncryptedVaultEncryptionKey());
        PowerAuthClientVault vault = new PowerAuthClientVault();
        SecretKey vaultEncryptionKey = vault.decryptVaultEncryptionKey(encryptedVaultEncryptionKey, transportMasterKey);
        PrivateKey devicePrivateKey = vault.decryptDevicePrivateKey(encryptedDevicePrivateKeyBytes, vaultEncryptionKey);
        PublicKey serverPublicKey = resultStatusObject.getServerPublicKeyObject();
        SecretKey masterSecretKey = KEY_FACTORY.generateClientMasterSecretKey(devicePrivateKey, serverPublicKey);
        SecretKey transportKeyDeduced = KEY_FACTORY.generateServerTransportKey(masterSecretKey);
        boolean equal = transportKeyDeduced.equals(transportMasterKey);
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("activationId", resultStatusObject.getActivationId());
        objectMap.put("encryptedVaultEncryptionKey", BaseEncoding.base64().encode(encryptedVaultEncryptionKey));
        objectMap.put("transportMasterKey", BaseEncoding.base64().encode(KEY_CONVERTOR.convertSharedSecretKeyToBytes(transportMasterKey)));
        objectMap.put("vaultEncryptionKey", BaseEncoding.base64().encode(KEY_CONVERTOR.convertSharedSecretKeyToBytes(vaultEncryptionKey)));
        objectMap.put("devicePrivateKey", BaseEncoding.base64().encode(KEY_CONVERTOR.convertPrivateKeyToBytes(devicePrivateKey)));
        objectMap.put("privateKeyDecryptionSuccessful", equal ? "true" : "false");
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-vault-unlocked", "Vault Unlocked", "Secure vault was successfully unlocked", "OK", objectMap);
    }
}

