/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.exception.EciesException;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;

public class SecurityUtil {
    private static final EciesFactory ECIES_FACTORY = new EciesFactory();
    private static final KeyConvertor KEY_CONVERTOR = new KeyConvertor();

    public static EciesEncryptor createEncryptor(String applicationSecretValue, ResultStatusObject resultStatusObject, EciesSharedInfo1 sharedInfo) throws CryptoProviderException, GenericCryptoException, InvalidKeySpecException {
        byte[] applicationSecret = applicationSecretValue.getBytes(StandardCharsets.UTF_8);
        byte[] serverPublicKeyBytes = BaseEncoding.base64().decode((CharSequence)resultStatusObject.getServerPublicKey());
        byte[] transportMasterKeyBytes = BaseEncoding.base64().decode((CharSequence)resultStatusObject.getTransportMasterKey());
        ECPublicKey serverPublicKey = (ECPublicKey)KEY_CONVERTOR.convertBytesToPublicKey(serverPublicKeyBytes);
        return ECIES_FACTORY.getEciesEncryptorForActivation(serverPublicKey, applicationSecret, transportMasterKeyBytes, sharedInfo);
    }

    public static EciesCryptogram encryptObject(EciesEncryptor encryptor, Object value, boolean useIv) throws EciesException, IOException {
        ByteArrayOutputStream baosL = new ByteArrayOutputStream();
        RestClientConfiguration.defaultMapper().writeValue((OutputStream)baosL, value);
        return encryptor.encryptRequest(baosL.toByteArray(), useIv);
    }

    public static byte[] decryptBytesFromResponse(EciesEncryptor encryptor, EciesEncryptedResponse encryptedResponse) throws EciesException {
        byte[] macResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getMac());
        byte[] encryptedDataResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getEncryptedData());
        EciesCryptogram eciesCryptogramResponse = new EciesCryptogram(macResponse, encryptedDataResponse);
        return encryptor.decryptResponse(eciesCryptogramResponse);
    }

    public static EciesEncryptedRequest createEncryptedRequest(EciesCryptogram eciesCryptogram, boolean useIv) {
        EciesEncryptedRequest request = new EciesEncryptedRequest();
        request.setEncryptedData(BaseEncoding.base64().encode(eciesCryptogram.getEncryptedData()));
        request.setEphemeralPublicKey(BaseEncoding.base64().encode(eciesCryptogram.getEphemeralPublicKey()));
        request.setMac(BaseEncoding.base64().encode(eciesCryptogram.getMac()));
        request.setNonce(useIv ? BaseEncoding.base64().encode(eciesCryptogram.getNonce()) : null);
        return request;
    }
}

