/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.provider;

import io.getlime.security.powerauth.lib.provider.CryptoProviderUtil;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.jce.ECNamedCurveTable;
import org.spongycastle.jce.interfaces.ECPrivateKey;
import org.spongycastle.jce.interfaces.ECPublicKey;
import org.spongycastle.jce.spec.ECNamedCurveParameterSpec;
import org.spongycastle.jce.spec.ECParameterSpec;
import org.spongycastle.jce.spec.ECPrivateKeySpec;
import org.spongycastle.jce.spec.ECPublicKeySpec;
import org.spongycastle.math.ec.ECPoint;

public class CryptoProviderUtilsSpongyCastle
implements CryptoProviderUtil {
    @Override
    public String getProviderName() {
        return "SC";
    }

    @Override
    public byte[] convertPublicKeyToBytes(PublicKey publicKey) {
        return ((ECPublicKey)publicKey).getQ().getEncoded(false);
    }

    @Override
    public PublicKey convertBytesToPublicKey(byte[] keyBytes) throws InvalidKeySpecException {
        try {
            KeyFactory kf = KeyFactory.getInstance("ECDH", this.getProviderName());
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
            if (ecSpec == null) {
                return null;
            }
            ECPoint point = ecSpec.getCurve().decodePoint(keyBytes);
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)ecSpec);
            ECPublicKey publicKey = (ECPublicKey)kf.generatePublic((KeySpec)pubSpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public byte[] convertPrivateKeyToBytes(PrivateKey privateKey) {
        byte[] pkBytes = ((ECPrivateKey)privateKey).getD().toByteArray();
        return pkBytes;
    }

    @Override
    public PrivateKey convertBytesToPrivateKey(byte[] keyBytes) throws InvalidKeySpecException {
        try {
            KeyFactory kf = KeyFactory.getInstance("ECDH", this.getProviderName());
            BigInteger keyInteger = new BigInteger(keyBytes);
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
            ECPrivateKeySpec pubSpec = new ECPrivateKeySpec(keyInteger, (ECParameterSpec)ecSpec);
            ECPrivateKey privateKey = (ECPrivateKey)kf.generatePrivate((KeySpec)pubSpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public byte[] convertSharedSecretKeyToBytes(SecretKey sharedSecretKey) {
        return sharedSecretKey.getEncoded();
    }

    @Override
    public SecretKey convertBytesToSharedSecretKey(byte[] bytesSecretKey) {
        return new SecretKeySpec(bytesSecretKey, "AES/ECB/NoPadding");
    }
}

