/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.provider;

import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import io.getlime.security.powerauth.provider.exception.CryptoProviderException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.jce.ECNamedCurveTable;
import org.spongycastle.jce.interfaces.ECPrivateKey;
import org.spongycastle.jce.interfaces.ECPublicKey;
import org.spongycastle.jce.spec.ECNamedCurveParameterSpec;
import org.spongycastle.jce.spec.ECParameterSpec;
import org.spongycastle.jce.spec.ECPrivateKeySpec;
import org.spongycastle.jce.spec.ECPublicKeySpec;
import org.spongycastle.math.ec.ECPoint;

public class CryptoProviderUtilsSpongyCastle
implements CryptoProviderUtil {
    @Override
    public String getProviderName() {
        return "SC";
    }

    @Override
    public byte[] convertPublicKeyToBytes(PublicKey publicKey) {
        return ((ECPublicKey)publicKey).getQ().getEncoded(false);
    }

    @Override
    public PublicKey convertBytesToPublicKey(byte[] keyBytes) throws InvalidKeySpecException, CryptoProviderException {
        try {
            KeyFactory kf = KeyFactory.getInstance("ECDH", this.getProviderName());
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
            if (ecSpec == null) {
                throw new CryptoProviderException("Crypto provider does not support the secp256r1 curve");
            }
            ECPoint point = ecSpec.getCurve().decodePoint(keyBytes);
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)ecSpec);
            return kf.generatePublic((KeySpec)pubSpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new CryptoProviderException(ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] convertPrivateKeyToBytes(PrivateKey privateKey) {
        return ((ECPrivateKey)privateKey).getD().toByteArray();
    }

    @Override
    public PrivateKey convertBytesToPrivateKey(byte[] keyBytes) throws InvalidKeySpecException, CryptoProviderException {
        try {
            KeyFactory kf = KeyFactory.getInstance("ECDH", this.getProviderName());
            BigInteger keyInteger = new BigInteger(keyBytes);
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
            ECPrivateKeySpec pubSpec = new ECPrivateKeySpec(keyInteger, (ECParameterSpec)ecSpec);
            return kf.generatePrivate((KeySpec)pubSpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new CryptoProviderException(ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] convertSharedSecretKeyToBytes(SecretKey sharedSecretKey) {
        return sharedSecretKey.getEncoded();
    }

    @Override
    public SecretKey convertBytesToSharedSecretKey(byte[] bytesSecretKey) {
        return new SecretKeySpec(bytesSecretKey, "AES/ECB/NoPadding");
    }
}

