/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.push.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.core.rest.model.base.entity.Error;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ErrorResponse;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.push.client.MobilePlatform;
import io.getlime.push.client.PushServerClientException;
import io.getlime.push.model.CreateDeviceRegistrationRequest;
import io.getlime.push.model.SendBatchMessageRequest;
import io.getlime.push.model.SendPushMessageRequest;
import io.getlime.push.model.entity.PushMessage;
import io.getlime.push.model.entity.PushSendResult;
import java.io.IOException;
import java.util.List;

public class PushServerClient {
    private ObjectMapper jacksonObjectMapper = new ObjectMapper();
    private String serviceBaseUrl;

    public PushServerClient() {
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)new com.mashape.unirest.http.ObjectMapper(){

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)PushServerClient.this.jacksonObjectMapper.readValue(value, valueType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String writeValue(Object value) {
                try {
                    return PushServerClient.this.jacksonObjectMapper.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public PushServerClient(String serviceBaseUrl) {
        this();
        this.serviceBaseUrl = serviceBaseUrl;
    }

    public void setServiceBaseUrl(String serviceBaseUrl) {
        this.serviceBaseUrl = serviceBaseUrl;
    }

    public boolean registerDevice(Long appId, String token, MobilePlatform platform) throws PushServerClientException {
        return this.registerDevice(appId, token, platform, null);
    }

    public boolean registerDevice(Long appId, String token, MobilePlatform platform, String activationId) throws PushServerClientException {
        CreateDeviceRegistrationRequest request = new CreateDeviceRegistrationRequest();
        request.setAppId(appId);
        request.setToken(token);
        request.setPlatform(platform.value());
        request.setActivationId(activationId);
        TypeReference<ObjectResponse> typeReference = new TypeReference<ObjectResponse>(){};
        ObjectResponse response = this.sendObjectImpl("/push/device/create", new ObjectRequest((Object)request), (TypeReference)typeReference);
        return response.getStatus().equals("OK");
    }

    public ObjectResponse<PushSendResult> sendNotification(Long appId, PushMessage pushMessage) throws PushServerClientException {
        SendPushMessageRequest request = new SendPushMessageRequest();
        request.setAppId(appId);
        request.setPush(pushMessage);
        TypeReference<ObjectResponse<PushSendResult>> typeReference = new TypeReference<ObjectResponse<PushSendResult>>(){};
        return this.sendObjectImpl("/push/message/send", new ObjectRequest((Object)request), (TypeReference)typeReference);
    }

    public ObjectResponse<PushSendResult> sendNotificationBatch(Long appId, List<PushMessage> batch) throws PushServerClientException {
        SendBatchMessageRequest request = new SendBatchMessageRequest();
        request.setAppId(appId);
        request.setBatch(batch);
        TypeReference<ObjectResponse<PushSendResult>> typeReference = new TypeReference<ObjectResponse<PushSendResult>>(){};
        return this.sendObjectImpl("/push/message/batch/send", new ObjectRequest((Object)request), (TypeReference)typeReference);
    }

    private <T> ObjectResponse<T> sendObjectImpl(String url, Object request, TypeReference typeReference) throws PushServerClientException {
        try {
            HttpResponse response = Unirest.post((String)(this.serviceBaseUrl + url)).header("accept", "application/json").header("Content-Type", "application/json").body(request).asString();
            if (response.getStatus() == 200) {
                return (ObjectResponse)this.jacksonObjectMapper.readValue(response.getRawBody(), typeReference);
            }
            ObjectMapper mapper = new ObjectMapper();
            ErrorResponse errResp = (ErrorResponse)mapper.readValue(response.getRawBody(), ErrorResponse.class);
            throw new PushServerClientException(response.getStatusText(), (Error)errResp.getResponseObject());
        }
        catch (UnirestException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
        }
        catch (JsonParseException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON parsing has failed."));
        }
        catch (JsonMappingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON mapping has failed."));
        }
        catch (IOException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Unknown IO error."));
        }
    }
}

