/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.push.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.core.rest.model.base.entity.Error;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ErrorResponse;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.push.client.MobilePlatform;
import io.getlime.push.client.PushServerClientException;
import io.getlime.push.model.base.PagedResponse;
import io.getlime.push.model.entity.ListOfUsers;
import io.getlime.push.model.entity.PushMessage;
import io.getlime.push.model.entity.PushMessageBody;
import io.getlime.push.model.entity.PushMessageSendResult;
import io.getlime.push.model.request.CreateCampaignRequest;
import io.getlime.push.model.request.CreateDeviceRequest;
import io.getlime.push.model.request.DeleteDeviceRequest;
import io.getlime.push.model.request.SendPushMessageBatchRequest;
import io.getlime.push.model.request.SendPushMessageRequest;
import io.getlime.push.model.request.TestCampaignRequest;
import io.getlime.push.model.request.UpdateDeviceStatusRequest;
import io.getlime.push.model.response.CampaignResponse;
import io.getlime.push.model.response.CreateCampaignResponse;
import io.getlime.push.model.response.DeleteCampaignResponse;
import io.getlime.push.model.response.ListOfCampaignsResponse;
import io.getlime.push.model.response.ListOfUsersFromCampaignResponse;
import io.getlime.push.model.response.ServiceStatusResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushServerClient {
    private ObjectMapper jacksonObjectMapper = new ObjectMapper();
    private String serviceBaseUrl;

    public PushServerClient() {
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)new com.mashape.unirest.http.ObjectMapper(){

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)PushServerClient.this.jacksonObjectMapper.readValue(value, valueType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String writeValue(Object value) {
                try {
                    return PushServerClient.this.jacksonObjectMapper.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public PushServerClient(String serviceBaseUrl) {
        this();
        this.serviceBaseUrl = serviceBaseUrl;
    }

    public void setServiceBaseUrl(String serviceBaseUrl) {
        this.serviceBaseUrl = serviceBaseUrl;
    }

    public ObjectResponse<ServiceStatusResponse> getServiceStatus() throws PushServerClientException {
        TypeReference<ObjectResponse<ServiceStatusResponse>> typeReference = new TypeReference<ObjectResponse<ServiceStatusResponse>>(){};
        return (ObjectResponse)this.getObjectImpl("/push/service/status", null, (TypeReference)typeReference);
    }

    public boolean createDevice(Long appId, String token, MobilePlatform platform) throws PushServerClientException {
        return this.createDevice(appId, token, platform, null);
    }

    public boolean createDevice(Long appId, String token, MobilePlatform platform, String activationId) throws PushServerClientException {
        CreateDeviceRequest request = new CreateDeviceRequest();
        request.setAppId(appId);
        request.setToken(token);
        request.setPlatform(platform.value());
        request.setActivationId(activationId);
        TypeReference<Response> typeReference = new TypeReference<Response>(){};
        Response response = (Response)this.postObjectImpl("/push/device/create", new ObjectRequest((Object)request), (TypeReference)typeReference);
        return response.getStatus().equals("OK");
    }

    public boolean deleteDevice(Long appId, String token) throws PushServerClientException {
        DeleteDeviceRequest request = new DeleteDeviceRequest();
        request.setAppId(appId);
        request.setToken(token);
        TypeReference<Response> typeReference = new TypeReference<Response>(){};
        Response response = (Response)this.postObjectImpl("/push/device/delete", new ObjectRequest((Object)request), (TypeReference)typeReference);
        return response.getStatus().equals("OK");
    }

    public boolean updateDeviceStatus(String activationId) throws PushServerClientException {
        UpdateDeviceStatusRequest request = new UpdateDeviceStatusRequest();
        request.setActivationId(activationId);
        TypeReference<Response> typeReference = new TypeReference<Response>(){};
        Response response = (Response)this.postObjectImpl("/push/device/status/update", request, (TypeReference)typeReference);
        return response.getStatus().equals("OK");
    }

    public ObjectResponse<PushMessageSendResult> sendPushMessage(Long appId, PushMessage pushMessage) throws PushServerClientException {
        SendPushMessageRequest request = new SendPushMessageRequest();
        request.setAppId(appId);
        request.setMessage(pushMessage);
        TypeReference<ObjectResponse<PushMessageSendResult>> typeReference = new TypeReference<ObjectResponse<PushMessageSendResult>>(){};
        return (ObjectResponse)this.postObjectImpl("/push/message/send", new ObjectRequest((Object)request), (TypeReference)typeReference);
    }

    public ObjectResponse<PushMessageSendResult> sendPushMessageBatch(Long appId, List<PushMessage> batch) throws PushServerClientException {
        SendPushMessageBatchRequest request = new SendPushMessageBatchRequest();
        request.setAppId(appId);
        request.setBatch(batch);
        TypeReference<ObjectResponse<PushMessageSendResult>> typeReference = new TypeReference<ObjectResponse<PushMessageSendResult>>(){};
        return (ObjectResponse)this.postObjectImpl("/push/message/batch/send", new ObjectRequest((Object)request), (TypeReference)typeReference);
    }

    public ObjectResponse<CreateCampaignResponse> createCampaign(Long appId, PushMessageBody message) throws PushServerClientException {
        CreateCampaignRequest request = new CreateCampaignRequest();
        request.setAppId(appId);
        request.setMessage(message);
        TypeReference<ObjectResponse<CreateCampaignResponse>> typeReference = new TypeReference<ObjectResponse<CreateCampaignResponse>>(){};
        return (ObjectResponse)this.postObjectImpl("/push/campaign/create", new ObjectRequest((Object)request), (TypeReference)typeReference);
    }

    public boolean deleteCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "utf-8");
            TypeReference<ObjectResponse<DeleteCampaignResponse>> typeReference = new TypeReference<ObjectResponse<DeleteCampaignResponse>>(){};
            ObjectResponse response = (ObjectResponse)this.postObjectImpl("/push/campaign/" + campaignIdSanitized + "/delete", null, (TypeReference)typeReference);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public ObjectResponse<ListOfCampaignsResponse> getListOfCampaigns(boolean all) throws PushServerClientException {
        TypeReference<ObjectResponse<ListOfCampaignsResponse>> typeReference = new TypeReference<ObjectResponse<ListOfCampaignsResponse>>(){};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("all", all);
        return (ObjectResponse)this.getObjectImpl("/push/campaign/list", params, (TypeReference)typeReference);
    }

    public ObjectResponse<CampaignResponse> getCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "utf-8");
            TypeReference<ObjectResponse<CampaignResponse>> typeReference = new TypeReference<ObjectResponse<CampaignResponse>>(){};
            return (ObjectResponse)this.getObjectImpl("/push/campaign/" + campaignIdSanitized + "/detail", null, (TypeReference)typeReference);
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean addUsersToCampaign(Long campaignId, List<String> users) throws PushServerClientException {
        try {
            ListOfUsers listOfUsers = new ListOfUsers();
            listOfUsers.addAll(users);
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "utf-8");
            TypeReference<Response> typeReference = new TypeReference<Response>(){};
            Response response = (Response)this.putObjectImpl("/push/campaign/" + campaignIdSanitized + "/user/add", new ObjectRequest((Object)listOfUsers), (TypeReference)typeReference);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public PagedResponse<ListOfUsersFromCampaignResponse> getListOfUsersFromCampaign(Long campaignId, int page, int size) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "utf-8");
            TypeReference<PagedResponse<ListOfUsersFromCampaignResponse>> typeReference = new TypeReference<PagedResponse<ListOfUsersFromCampaignResponse>>(){};
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("page", page);
            params.put("size", size);
            return (PagedResponse)this.getObjectImpl("/push/campaign/" + campaignIdSanitized + "/user/list", params, (TypeReference)typeReference);
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean deleteUsersFromCampaign(Long campaignId, List<String> users) throws PushServerClientException {
        try {
            ListOfUsers listOfUsers = new ListOfUsers();
            listOfUsers.addAll(users);
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "utf-8");
            TypeReference<Response> typeReference = new TypeReference<Response>(){};
            Response response = (Response)this.postObjectImpl("/push/campaign/" + campaignIdSanitized + "/user/delete", new ObjectRequest((Object)listOfUsers), (TypeReference)typeReference);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean sendTestCampaign(Long campaignId, String userId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "utf-8");
            TestCampaignRequest testCampaignRequest = new TestCampaignRequest();
            testCampaignRequest.setUserId(userId);
            TypeReference<Response> typeReference = new TypeReference<Response>(){};
            Response response = (Response)this.postObjectImpl("/push/campaign/send/test/" + campaignIdSanitized, new ObjectRequest((Object)testCampaignRequest), (TypeReference)typeReference);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean sendCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "utf-8");
            TypeReference<Response> typeReference = new TypeReference<Response>(){};
            Response response = (Response)this.postObjectImpl("/push/campaign/send/live/" + campaignIdSanitized, null, (TypeReference)typeReference);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    private <T> T getObjectImpl(String url, Map<String, Object> params, TypeReference typeReference) throws PushServerClientException {
        try {
            HttpResponse response = Unirest.get((String)(this.serviceBaseUrl + url)).header("accept", "application/json").header("Content-Type", "application/json").queryString(params).asString();
            return this.checkHttpStatus(typeReference, response);
        }
        catch (UnirestException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
        }
        catch (JsonParseException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON parsing has failed."));
        }
        catch (JsonMappingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON mapping has failed."));
        }
        catch (IOException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Unknown IO error."));
        }
    }

    private <T> T postObjectImpl(String url, Object request, TypeReference typeReference) throws PushServerClientException {
        try {
            HttpResponse response = Unirest.post((String)(this.serviceBaseUrl + url)).header("accept", "application/json").header("Content-Type", "application/json").body(request).asString();
            return this.checkHttpStatus(typeReference, response);
        }
        catch (UnirestException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
        }
        catch (JsonParseException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON parsing has failed."));
        }
        catch (JsonMappingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON mapping has failed."));
        }
        catch (IOException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Unknown IO error."));
        }
    }

    private <T> T putObjectImpl(String url, Object request, TypeReference typeReference) throws PushServerClientException {
        try {
            HttpResponse response = Unirest.put((String)(this.serviceBaseUrl + url)).header("accept", "application/json").header("Content-Type", "application/json").body(request).asString();
            return this.checkHttpStatus(typeReference, response);
        }
        catch (UnirestException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
        }
        catch (JsonParseException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON parsing has failed."));
        }
        catch (JsonMappingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON mapping has failed."));
        }
        catch (IOException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Unknown IO error."));
        }
    }

    private <T> T checkHttpStatus(TypeReference typeReference, HttpResponse response) throws IOException, PushServerClientException {
        if (response.getStatus() == 200) {
            return (T)this.jacksonObjectMapper.readValue(response.getRawBody(), typeReference);
        }
        ObjectMapper mapper = new ObjectMapper();
        ErrorResponse errorResponse = (ErrorResponse)mapper.readValue(response.getRawBody(), ErrorResponse.class);
        throw new PushServerClientException(response.getStatusText(), (Error)errorResponse.getResponseObject());
    }
}

