/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.push.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.core.rest.model.base.entity.Error;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ErrorResponse;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.push.client.MobilePlatform;
import io.getlime.push.client.PushServerClientException;
import io.getlime.push.model.base.PagedResponse;
import io.getlime.push.model.entity.ListOfUsers;
import io.getlime.push.model.entity.PushMessage;
import io.getlime.push.model.entity.PushMessageBody;
import io.getlime.push.model.entity.PushMessageSendResult;
import io.getlime.push.model.request.CreateCampaignRequest;
import io.getlime.push.model.request.CreateDeviceRequest;
import io.getlime.push.model.request.DeleteDeviceRequest;
import io.getlime.push.model.request.SendPushMessageBatchRequest;
import io.getlime.push.model.request.SendPushMessageRequest;
import io.getlime.push.model.request.TestCampaignRequest;
import io.getlime.push.model.request.UpdateDeviceStatusRequest;
import io.getlime.push.model.response.CampaignResponse;
import io.getlime.push.model.response.CreateCampaignResponse;
import io.getlime.push.model.response.DeleteCampaignResponse;
import io.getlime.push.model.response.ListOfCampaignsResponse;
import io.getlime.push.model.response.ListOfUsersFromCampaignResponse;
import io.getlime.push.model.response.ServiceStatusResponse;
import io.getlime.push.model.validator.CreateCampaignRequestValidator;
import io.getlime.push.model.validator.CreateDeviceRequestValidator;
import io.getlime.push.model.validator.DeleteDeviceRequestValidator;
import io.getlime.push.model.validator.SendPushMessageBatchRequestValidator;
import io.getlime.push.model.validator.SendPushMessageRequestValidator;
import io.getlime.push.model.validator.TestCampaignRequestValidator;
import io.getlime.push.model.validator.UpdateDeviceStatusRequestValidator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PushServerClient {
    private ObjectMapper jacksonObjectMapper = new ObjectMapper();
    private String serviceBaseUrl;

    public PushServerClient() {
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)new com.mashape.unirest.http.ObjectMapper(){

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)PushServerClient.this.jacksonObjectMapper.readValue(value, valueType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String writeValue(Object value) {
                try {
                    return PushServerClient.this.jacksonObjectMapper.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public PushServerClient(String serviceBaseUrl) {
        this();
        this.serviceBaseUrl = serviceBaseUrl;
    }

    public void setServiceBaseUrl(String serviceBaseUrl) {
        this.serviceBaseUrl = serviceBaseUrl;
    }

    public ObjectResponse<ServiceStatusResponse> getServiceStatus() throws PushServerClientException {
        TypeReference<ObjectResponse<ServiceStatusResponse>> typeReference = new TypeReference<ObjectResponse<ServiceStatusResponse>>(){};
        this.log("Calling push server status service - start");
        ObjectResponse result = (ObjectResponse)this.getObjectImpl("/push/service/status", null, (TypeReference)typeReference);
        this.log("Calling push server status service - finish");
        return result;
    }

    public boolean createDevice(Long appId, String token, MobilePlatform platform) throws PushServerClientException {
        return this.createDevice(appId, token, platform, null);
    }

    public boolean createDevice(Long appId, String token, MobilePlatform platform, String activationId) throws PushServerClientException {
        CreateDeviceRequest request = new CreateDeviceRequest();
        request.setAppId(appId);
        request.setToken(token);
        request.setPlatform(platform.value());
        request.setActivationId(activationId);
        String error = CreateDeviceRequestValidator.validate((CreateDeviceRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        this.log("Calling create device service, appId: {0}, token: {1}, platform: {2} - start", new String[]{String.valueOf(appId), token, platform.value()});
        Response response = (Response)this.postObjectImpl("/push/device/create", new ObjectRequest((Object)request));
        this.log("Calling create device service, appId: {0}, token: {1}, platform: {2} - finish", new String[]{String.valueOf(appId), token, platform.value()});
        return response.getStatus().equals("OK");
    }

    public boolean deleteDevice(Long appId, String token) throws PushServerClientException {
        DeleteDeviceRequest request = new DeleteDeviceRequest();
        request.setAppId(appId);
        request.setToken(token);
        String error = DeleteDeviceRequestValidator.validate((DeleteDeviceRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        this.log("Calling push server delete device service, appId: {0}, token: {1} - start", new String[]{String.valueOf(appId), token});
        Response response = (Response)this.postObjectImpl("/push/device/delete", new ObjectRequest((Object)request));
        this.log("Calling push server delete device service, appId: {0}, token: {1} - finish", new String[]{String.valueOf(appId), token});
        return response.getStatus().equals("OK");
    }

    public boolean updateDeviceStatus(String activationId) throws PushServerClientException {
        UpdateDeviceStatusRequest request = new UpdateDeviceStatusRequest();
        request.setActivationId(activationId);
        String error = UpdateDeviceStatusRequestValidator.validate((UpdateDeviceStatusRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        this.log("Calling push server update device status, activation ID: {0} - start", new String[]{activationId});
        Response response = (Response)this.postObjectImpl("/push/device/status/update", request);
        this.log("Calling push server update device status, activation ID: {0} - finish", new String[]{activationId});
        return response.getStatus().equals("OK");
    }

    public ObjectResponse<PushMessageSendResult> sendPushMessage(Long appId, PushMessage pushMessage) throws PushServerClientException {
        SendPushMessageRequest request = new SendPushMessageRequest();
        request.setAppId(appId);
        request.setMessage(pushMessage);
        String error = SendPushMessageRequestValidator.validate((SendPushMessageRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        TypeReference<ObjectResponse<PushMessageSendResult>> typeReference = new TypeReference<ObjectResponse<PushMessageSendResult>>(){};
        this.log("Calling push server to send a push message, app ID: {0}, user ID: {1} - start", new String[]{String.valueOf(appId), pushMessage.getUserId()});
        ObjectResponse result = (ObjectResponse)this.postObjectImpl("/push/message/send", new ObjectRequest((Object)request), (TypeReference)typeReference);
        this.log("Calling push server to send a push message, app ID: {0}, user ID: {1} - finish", new String[]{String.valueOf(appId), pushMessage.getUserId()});
        return result;
    }

    public ObjectResponse<PushMessageSendResult> sendPushMessageBatch(Long appId, List<PushMessage> batch) throws PushServerClientException {
        SendPushMessageBatchRequest request = new SendPushMessageBatchRequest();
        request.setAppId(appId);
        request.setBatch(batch);
        String error = SendPushMessageBatchRequestValidator.validate((SendPushMessageBatchRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        TypeReference<ObjectResponse<PushMessageSendResult>> typeReference = new TypeReference<ObjectResponse<PushMessageSendResult>>(){};
        this.log("Calling push server to send a push message batch, app ID: {0} - start", new String[]{String.valueOf(appId)});
        ObjectResponse result = (ObjectResponse)this.postObjectImpl("/push/message/batch/send", new ObjectRequest((Object)request), (TypeReference)typeReference);
        this.log("Calling push server to send a push message batch, app ID: {0} - finish", new String[]{String.valueOf(appId)});
        return result;
    }

    public ObjectResponse<CreateCampaignResponse> createCampaign(Long appId, PushMessageBody message) throws PushServerClientException {
        CreateCampaignRequest request = new CreateCampaignRequest();
        request.setAppId(appId);
        request.setMessage(message);
        String error = CreateCampaignRequestValidator.validate((CreateCampaignRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        TypeReference<ObjectResponse<CreateCampaignResponse>> typeReference = new TypeReference<ObjectResponse<CreateCampaignResponse>>(){};
        this.log("Calling push server to create a push campaign, app ID: {0} - start", new String[]{String.valueOf(appId)});
        ObjectResponse result = (ObjectResponse)this.postObjectImpl("/push/campaign/create", new ObjectRequest((Object)request), (TypeReference)typeReference);
        this.log("Calling push server to create a push campaign, app ID: {0} - finish", new String[]{String.valueOf(appId)});
        return result;
    }

    public boolean deleteCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            TypeReference<ObjectResponse<DeleteCampaignResponse>> typeReference = new TypeReference<ObjectResponse<DeleteCampaignResponse>>(){};
            this.log("Calling push server to delete a push campaign, campaign ID: {0} - start", new String[]{String.valueOf(campaignId)});
            ObjectResponse response = (ObjectResponse)this.postObjectImpl("/push/campaign/" + campaignIdSanitized + "/delete", null, (TypeReference)typeReference);
            this.log("Calling push server to delete a push campaign, campaign ID: {0} - finish", new String[]{String.valueOf(campaignId)});
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public ObjectResponse<ListOfCampaignsResponse> getListOfCampaigns(boolean all) throws PushServerClientException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("all", all);
        TypeReference<ObjectResponse<ListOfCampaignsResponse>> typeReference = new TypeReference<ObjectResponse<ListOfCampaignsResponse>>(){};
        this.log("Calling push server to obtain a push campaign list - start");
        ObjectResponse result = (ObjectResponse)this.getObjectImpl("/push/campaign/list", params, (TypeReference)typeReference);
        this.log("Calling push server to obtain a push campaign list - finish");
        return result;
    }

    public ObjectResponse<CampaignResponse> getCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            TypeReference<ObjectResponse<CampaignResponse>> typeReference = new TypeReference<ObjectResponse<CampaignResponse>>(){};
            this.log("Calling push server to obtain a push campaign detail, campaign ID: {0} - start", new String[]{String.valueOf(campaignId)});
            ObjectResponse result = (ObjectResponse)this.getObjectImpl("/push/campaign/" + campaignIdSanitized + "/detail", null, (TypeReference)typeReference);
            this.log("Calling push server to obtain a push campaign detail, campaign ID: {0} - finish", new String[]{String.valueOf(campaignId)});
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean addUsersToCampaign(Long campaignId, List<String> users) throws PushServerClientException {
        try {
            ListOfUsers listOfUsers = new ListOfUsers(users);
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            this.log("Calling push server to add users to campaign, campaign ID: {0} - start", new String[]{String.valueOf(campaignId)});
            Response response = (Response)this.putObjectImpl("/push/campaign/" + campaignIdSanitized + "/user/add", new ObjectRequest((Object)listOfUsers));
            this.log("Calling push server to add users to campaign, campaign ID: {0} - finish", new String[]{String.valueOf(campaignId)});
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public PagedResponse<ListOfUsersFromCampaignResponse> getListOfUsersFromCampaign(Long campaignId, int page, int size) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("page", page);
            params.put("size", size);
            TypeReference<PagedResponse<ListOfUsersFromCampaignResponse>> typeReference = new TypeReference<PagedResponse<ListOfUsersFromCampaignResponse>>(){};
            this.log("Calling push server to get users from the campaign, campaign ID: {0} - start", new String[]{String.valueOf(campaignId)});
            PagedResponse result = (PagedResponse)this.getObjectImpl("/push/campaign/" + campaignIdSanitized + "/user/list", params, (TypeReference)typeReference);
            this.log("Calling push server to get users from the campaign, campaign ID: {0} - finish", new String[]{String.valueOf(campaignId)});
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean deleteUsersFromCampaign(Long campaignId, List<String> users) throws PushServerClientException {
        try {
            ListOfUsers listOfUsers = new ListOfUsers(users);
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            this.log("Calling push server to remove users from the campaign, campaign ID: {0} - start", new String[]{String.valueOf(campaignId)});
            Response response = (Response)this.postObjectImpl("/push/campaign/" + campaignIdSanitized + "/user/delete", new ObjectRequest((Object)listOfUsers));
            this.log("Calling push server to remove users from the campaign, campaign ID: {0} - finish", new String[]{String.valueOf(campaignId)});
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean sendTestCampaign(Long campaignId, String userId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            TestCampaignRequest request = new TestCampaignRequest();
            request.setUserId(userId);
            String error = TestCampaignRequestValidator.validate((TestCampaignRequest)request);
            if (error != null) {
                throw new PushServerClientException(error);
            }
            this.log("Calling push server to send test campaign, campaign ID: {0}, user ID: {1} - start", new String[]{String.valueOf(campaignId), userId});
            Response response = (Response)this.postObjectImpl("/push/campaign/send/test/" + campaignIdSanitized, new ObjectRequest((Object)request));
            this.log("Calling push server to send test campaign, campaign ID: {0}, user ID: {1} - finish", new String[]{String.valueOf(campaignId), userId});
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean sendCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            this.log("Calling push server to send a production campaign, campaign ID: {0} - start", new String[]{String.valueOf(campaignId)});
            Response response = (Response)this.postObjectImpl("/push/campaign/send/live/" + campaignIdSanitized, null);
            this.log("Calling push server to send a production campaign, campaign ID: {0} - finish", new String[]{String.valueOf(campaignId)});
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    private <T> T getObjectImpl(String url, Map<String, Object> params) throws PushServerClientException {
        return this.getObjectImpl(url, params, (TypeReference)new TypeReference<Response>(){});
    }

    private <T> T getObjectImpl(String url, Map<String, Object> params, TypeReference typeReference) throws PushServerClientException {
        try {
            HttpResponse response = Unirest.get((String)(this.serviceBaseUrl + url)).header("Accept", "application/json").header("Content-Type", "application/json").queryString(params).asString();
            return this.checkHttpStatus(typeReference, response);
        }
        catch (UnirestException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
        }
        catch (JsonParseException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON parsing has failed."));
        }
        catch (JsonMappingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON mapping has failed."));
        }
        catch (IOException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Unknown IO error."));
        }
    }

    private <T> T postObjectImpl(String url, Object request) throws PushServerClientException {
        return this.postObjectImpl(url, request, (TypeReference)new TypeReference<Response>(){});
    }

    private <T> T postObjectImpl(String url, Object request, TypeReference typeReference) throws PushServerClientException {
        try {
            HttpResponse response = Unirest.post((String)(this.serviceBaseUrl + url)).header("Accept", "application/json").header("Content-Type", "application/json").body(request).asString();
            return this.checkHttpStatus(typeReference, response);
        }
        catch (UnirestException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
        }
        catch (JsonParseException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON parsing has failed."));
        }
        catch (JsonMappingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON mapping has failed."));
        }
        catch (IOException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Unknown IO error."));
        }
    }

    private <T> T putObjectImpl(String url, Object request) throws PushServerClientException {
        return this.putObjectImpl(url, request, (TypeReference)new TypeReference<Response>(){});
    }

    private <T> T putObjectImpl(String url, Object request, TypeReference typeReference) throws PushServerClientException {
        try {
            HttpResponse response = Unirest.put((String)(this.serviceBaseUrl + url)).header("Accept", "application/json").header("Content-Type", "application/json").body(request).asString();
            return this.checkHttpStatus(typeReference, response);
        }
        catch (UnirestException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
        }
        catch (JsonParseException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON parsing has failed."));
        }
        catch (JsonMappingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "JSON mapping has failed."));
        }
        catch (IOException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Unknown IO error."));
        }
    }

    private <T> T checkHttpStatus(TypeReference typeReference, HttpResponse response) throws IOException, PushServerClientException {
        if (response.getStatus() == 200) {
            return (T)this.jacksonObjectMapper.readValue(response.getRawBody(), typeReference);
        }
        ObjectMapper mapper = new ObjectMapper();
        ErrorResponse errorResponse = (ErrorResponse)mapper.readValue(response.getRawBody(), ErrorResponse.class);
        throw new PushServerClientException(response.getStatusText(), (Error)errorResponse.getResponseObject());
    }

    private void log(String msg) {
        Logger.getLogger(PushServerClient.class.getName()).log(Level.INFO, msg);
    }

    private void log(String msg, String[] params) {
        Logger.getLogger(PushServerClient.class.getName()).log(Level.INFO, msg, params);
    }
}

