/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.push.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.core.rest.model.base.entity.Error;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ErrorResponse;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.push.client.MobilePlatform;
import io.getlime.push.client.PushServerClientException;
import io.getlime.push.model.base.PagedResponse;
import io.getlime.push.model.entity.ListOfUsers;
import io.getlime.push.model.entity.PushMessage;
import io.getlime.push.model.entity.PushMessageBody;
import io.getlime.push.model.entity.PushMessageSendResult;
import io.getlime.push.model.request.CreateApplicationRequest;
import io.getlime.push.model.request.CreateCampaignRequest;
import io.getlime.push.model.request.CreateDeviceRequest;
import io.getlime.push.model.request.DeleteDeviceRequest;
import io.getlime.push.model.request.GetApplicationDetailRequest;
import io.getlime.push.model.request.RemoveAndroidRequest;
import io.getlime.push.model.request.RemoveIosRequest;
import io.getlime.push.model.request.SendPushMessageBatchRequest;
import io.getlime.push.model.request.SendPushMessageRequest;
import io.getlime.push.model.request.TestCampaignRequest;
import io.getlime.push.model.request.UpdateAndroidRequest;
import io.getlime.push.model.request.UpdateDeviceStatusRequest;
import io.getlime.push.model.request.UpdateIosRequest;
import io.getlime.push.model.response.CampaignResponse;
import io.getlime.push.model.response.CreateApplicationResponse;
import io.getlime.push.model.response.CreateCampaignResponse;
import io.getlime.push.model.response.DeleteCampaignResponse;
import io.getlime.push.model.response.GetApplicationDetailResponse;
import io.getlime.push.model.response.GetApplicationListResponse;
import io.getlime.push.model.response.ListOfCampaignsResponse;
import io.getlime.push.model.response.ListOfUsersFromCampaignResponse;
import io.getlime.push.model.response.ServiceStatusResponse;
import io.getlime.push.model.validator.CreateCampaignRequestValidator;
import io.getlime.push.model.validator.CreateDeviceRequestValidator;
import io.getlime.push.model.validator.DeleteDeviceRequestValidator;
import io.getlime.push.model.validator.SendPushMessageBatchRequestValidator;
import io.getlime.push.model.validator.SendPushMessageRequestValidator;
import io.getlime.push.model.validator.TestCampaignRequestValidator;
import io.getlime.push.model.validator.UpdateDeviceStatusRequestValidator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushServerClient {
    private Logger logger = LoggerFactory.getLogger(PushServerClient.class);
    private ObjectMapper jacksonObjectMapper = new ObjectMapper();
    private String serviceBaseUrl;

    public PushServerClient() {
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)new com.mashape.unirest.http.ObjectMapper(){

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)PushServerClient.this.jacksonObjectMapper.readValue(value, valueType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String writeValue(Object value) {
                try {
                    return PushServerClient.this.jacksonObjectMapper.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public PushServerClient(String serviceBaseUrl) {
        this();
        this.serviceBaseUrl = serviceBaseUrl;
    }

    public void setServiceBaseUrl(String serviceBaseUrl) {
        this.serviceBaseUrl = serviceBaseUrl;
    }

    public ObjectResponse<ServiceStatusResponse> getServiceStatus() throws PushServerClientException {
        TypeReference<ObjectResponse<ServiceStatusResponse>> typeReference = new TypeReference<ObjectResponse<ServiceStatusResponse>>(){};
        this.logger.info("Calling push server status service - start");
        ObjectResponse result = (ObjectResponse)this.getObjectImpl("/push/service/status", null, (TypeReference)typeReference);
        this.logger.info("Calling push server status service - finish");
        return result;
    }

    public boolean createDevice(Long appId, String token, MobilePlatform platform) throws PushServerClientException {
        return this.createDevice(appId, token, platform, null);
    }

    public boolean createDevice(Long appId, String token, MobilePlatform platform, String activationId) throws PushServerClientException {
        CreateDeviceRequest request = new CreateDeviceRequest();
        request.setAppId(appId);
        request.setToken(token);
        request.setPlatform(platform.value());
        request.setActivationId(activationId);
        String error = CreateDeviceRequestValidator.validate((CreateDeviceRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        this.logger.info("Calling create device service, appId: {}, token: {}, platform: {} - start", new Object[]{appId, token, platform.value()});
        Response response = (Response)this.postObjectImpl("/push/device/create", new ObjectRequest((Object)request));
        this.logger.info("Calling create device service, appId: {}, token: {}, platform: {} - finish", new Object[]{appId, token, platform.value()});
        return response.getStatus().equals("OK");
    }

    public boolean deleteDevice(Long appId, String token) throws PushServerClientException {
        DeleteDeviceRequest request = new DeleteDeviceRequest();
        request.setAppId(appId);
        request.setToken(token);
        String error = DeleteDeviceRequestValidator.validate((DeleteDeviceRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        this.logger.info("Calling push server delete device service, appId: {}, token: {} - start", (Object)appId, (Object)token);
        Response response = (Response)this.postObjectImpl("/push/device/delete", new ObjectRequest((Object)request));
        this.logger.info("Calling push server delete device service, appId: {}, token: {} - finish", (Object)appId, (Object)token);
        return response.getStatus().equals("OK");
    }

    public boolean updateDeviceStatus(String activationId) throws PushServerClientException {
        UpdateDeviceStatusRequest request = new UpdateDeviceStatusRequest();
        request.setActivationId(activationId);
        String error = UpdateDeviceStatusRequestValidator.validate((UpdateDeviceStatusRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        this.logger.info("Calling push server update device status, activation ID: {} - start", (Object)activationId);
        Response response = (Response)this.postObjectImpl("/push/device/status/update", request);
        this.logger.info("Calling push server update device status, activation ID: {} - finish", (Object)activationId);
        return response.getStatus().equals("OK");
    }

    public ObjectResponse<PushMessageSendResult> sendPushMessage(Long appId, PushMessage pushMessage) throws PushServerClientException {
        SendPushMessageRequest request = new SendPushMessageRequest();
        request.setAppId(appId);
        request.setMessage(pushMessage);
        String error = SendPushMessageRequestValidator.validate((SendPushMessageRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        TypeReference<ObjectResponse<PushMessageSendResult>> typeReference = new TypeReference<ObjectResponse<PushMessageSendResult>>(){};
        this.logger.info("Calling push server to send a push message, app ID: {}, user ID: {} - start", (Object)appId, (Object)pushMessage.getUserId());
        ObjectResponse result = (ObjectResponse)this.postObjectImpl("/push/message/send", new ObjectRequest((Object)request), (TypeReference)typeReference);
        this.logger.info("Calling push server to send a push message, app ID: {}, user ID: {} - finish", (Object)appId, (Object)pushMessage.getUserId());
        return result;
    }

    public ObjectResponse<PushMessageSendResult> sendPushMessageBatch(Long appId, List<PushMessage> batch) throws PushServerClientException {
        SendPushMessageBatchRequest request = new SendPushMessageBatchRequest();
        request.setAppId(appId);
        request.setBatch(batch);
        String error = SendPushMessageBatchRequestValidator.validate((SendPushMessageBatchRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        TypeReference<ObjectResponse<PushMessageSendResult>> typeReference = new TypeReference<ObjectResponse<PushMessageSendResult>>(){};
        this.logger.info("Calling push server to send a push message batch, app ID: {} - start", (Object)appId);
        ObjectResponse result = (ObjectResponse)this.postObjectImpl("/push/message/batch/send", new ObjectRequest((Object)request), (TypeReference)typeReference);
        this.logger.info("Calling push server to send a push message batch, app ID: {} - finish", (Object)appId);
        return result;
    }

    public ObjectResponse<CreateCampaignResponse> createCampaign(Long appId, PushMessageBody message) throws PushServerClientException {
        CreateCampaignRequest request = new CreateCampaignRequest();
        request.setAppId(appId);
        request.setMessage(message);
        String error = CreateCampaignRequestValidator.validate((CreateCampaignRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        TypeReference<ObjectResponse<CreateCampaignResponse>> typeReference = new TypeReference<ObjectResponse<CreateCampaignResponse>>(){};
        this.logger.info("Calling push server to create a push campaign, app ID: {} - start", (Object)appId);
        ObjectResponse result = (ObjectResponse)this.postObjectImpl("/push/campaign/create", new ObjectRequest((Object)request), (TypeReference)typeReference);
        this.logger.info("Calling push server to create a push campaign, app ID: {} - finish", (Object)appId);
        return result;
    }

    public boolean deleteCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            TypeReference<ObjectResponse<DeleteCampaignResponse>> typeReference = new TypeReference<ObjectResponse<DeleteCampaignResponse>>(){};
            this.logger.info("Calling push server to delete a push campaign, campaign ID: {} - start", (Object)campaignId);
            ObjectResponse response = (ObjectResponse)this.postObjectImpl("/push/campaign/" + campaignIdSanitized + "/delete", null, (TypeReference)typeReference);
            this.logger.info("Calling push server to delete a push campaign, campaign ID: {} - finish", (Object)campaignId);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public ObjectResponse<ListOfCampaignsResponse> getListOfCampaigns(boolean all) throws PushServerClientException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("all", all);
        TypeReference<ObjectResponse<ListOfCampaignsResponse>> typeReference = new TypeReference<ObjectResponse<ListOfCampaignsResponse>>(){};
        this.logger.info("Calling push server to obtain a push campaign list - start");
        ObjectResponse result = (ObjectResponse)this.getObjectImpl("/push/campaign/list", params, (TypeReference)typeReference);
        this.logger.info("Calling push server to obtain a push campaign list - finish");
        return result;
    }

    public ObjectResponse<CampaignResponse> getCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            TypeReference<ObjectResponse<CampaignResponse>> typeReference = new TypeReference<ObjectResponse<CampaignResponse>>(){};
            this.logger.info("Calling push server to obtain a push campaign detail, campaign ID: {} - start", (Object)campaignId);
            ObjectResponse result = (ObjectResponse)this.getObjectImpl("/push/campaign/" + campaignIdSanitized + "/detail", null, (TypeReference)typeReference);
            this.logger.info("Calling push server to obtain a push campaign detail, campaign ID: {} - finish", (Object)campaignId);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean addUsersToCampaign(Long campaignId, List<String> users) throws PushServerClientException {
        try {
            ListOfUsers listOfUsers = new ListOfUsers(users);
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            this.logger.info("Calling push server to add users to campaign, campaign ID: {} - start", (Object)campaignId);
            Response response = (Response)this.putObjectImpl("/push/campaign/" + campaignIdSanitized + "/user/add", new ObjectRequest((Object)listOfUsers));
            this.logger.info("Calling push server to add users to campaign, campaign ID: {} - finish", (Object)campaignId);
            if (response == null) {
                throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
            }
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public PagedResponse<ListOfUsersFromCampaignResponse> getListOfUsersFromCampaign(Long campaignId, int page, int size) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("page", page);
            params.put("size", size);
            TypeReference<PagedResponse<ListOfUsersFromCampaignResponse>> typeReference = new TypeReference<PagedResponse<ListOfUsersFromCampaignResponse>>(){};
            this.logger.info("Calling push server to get users from the campaign, campaign ID: {} - start", (Object)campaignId);
            PagedResponse result = (PagedResponse)this.getObjectImpl("/push/campaign/" + campaignIdSanitized + "/user/list", params, (TypeReference)typeReference);
            this.logger.info("Calling push server to get users from the campaign, campaign ID: {} - finish", (Object)campaignId);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean deleteUsersFromCampaign(Long campaignId, List<String> users) throws PushServerClientException {
        try {
            ListOfUsers listOfUsers = new ListOfUsers(users);
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            this.logger.info("Calling push server to remove users from the campaign, campaign ID: {} - start", (Object)campaignId);
            Response response = (Response)this.postObjectImpl("/push/campaign/" + campaignIdSanitized + "/user/delete", new ObjectRequest((Object)listOfUsers));
            this.logger.info("Calling push server to remove users from the campaign, campaign ID: {} - finish", (Object)campaignId);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean sendTestCampaign(Long campaignId, String userId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            TestCampaignRequest request = new TestCampaignRequest();
            request.setUserId(userId);
            String error = TestCampaignRequestValidator.validate((TestCampaignRequest)request);
            if (error != null) {
                throw new PushServerClientException(error);
            }
            this.logger.info("Calling push server to send test campaign, campaign ID: {}, user ID: {} - start", (Object)campaignId, (Object)userId);
            Response response = (Response)this.postObjectImpl("/push/campaign/send/test/" + campaignIdSanitized, new ObjectRequest((Object)request));
            this.logger.info("Calling push server to send test campaign, campaign ID: {}, user ID: {} - finish", (Object)campaignId, (Object)userId);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean sendCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            this.logger.info("Calling push server to send a production campaign, campaign ID: {} - start", (Object)campaignId);
            Response response = (Response)this.postObjectImpl("/push/campaign/send/live/" + campaignIdSanitized, null);
            this.logger.info("Calling push server to send a production campaign, campaign ID: {} - finish", (Object)campaignId);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public ObjectResponse<GetApplicationListResponse> getApplicationList() throws PushServerClientException {
        TypeReference<ObjectResponse<GetApplicationListResponse>> typeReference = new TypeReference<ObjectResponse<GetApplicationListResponse>>(){};
        this.logger.info("Calling push server to retrieve list of applications - start");
        ObjectResponse response = (ObjectResponse)this.getObjectImpl("/admin/app/list", null, (TypeReference)typeReference);
        this.logger.info("Calling push server to retrieve list of applications - finish");
        return response;
    }

    public ObjectResponse<GetApplicationListResponse> getUnconfiguredApplicationList() throws PushServerClientException {
        TypeReference<ObjectResponse<GetApplicationListResponse>> typeReference = new TypeReference<ObjectResponse<GetApplicationListResponse>>(){};
        this.logger.info("Calling push server to retrieve list of unconfigured applications - start");
        ObjectResponse response = (ObjectResponse)this.getObjectImpl("/admin/app/unconfigured/list", null, (TypeReference)typeReference);
        this.logger.info("Calling push server to retrieve list of unconfigured applications - finish");
        return response;
    }

    public ObjectResponse<GetApplicationDetailResponse> getApplicationDetail(Long id, boolean includeIos, boolean includeAndroid) throws PushServerClientException {
        TypeReference<ObjectResponse<GetApplicationDetailResponse>> typeReference = new TypeReference<ObjectResponse<GetApplicationDetailResponse>>(){};
        GetApplicationDetailRequest request = new GetApplicationDetailRequest(id, includeIos, includeAndroid);
        this.logger.info("Calling push server to retrieve application detail, ID: {} - start", (Object)id);
        ObjectResponse response = (ObjectResponse)this.postObjectImpl("/admin/app/detail", new ObjectRequest((Object)request), (TypeReference)typeReference);
        this.logger.info("Calling push server to retrieve application detail, ID: {} - finish", (Object)id);
        return response;
    }

    public ObjectResponse<CreateApplicationResponse> createApplication(Long appId) throws PushServerClientException {
        TypeReference<ObjectResponse<CreateApplicationResponse>> typeReference = new TypeReference<ObjectResponse<CreateApplicationResponse>>(){};
        CreateApplicationRequest request = new CreateApplicationRequest(appId);
        this.logger.info("Calling push server to create application, app ID: {} - start", (Object)appId);
        ObjectResponse response = (ObjectResponse)this.postObjectImpl("/admin/app/create", new ObjectRequest((Object)request), (TypeReference)typeReference);
        this.logger.info("Calling push server to create application, app ID: {} - finish", (Object)appId);
        return response;
    }

    public Response updateIos(Long id, String bundle, String keyId, String teamId, byte[] privateKey) throws PushServerClientException {
        String privateKeyBase64 = BaseEncoding.base64().encode(privateKey);
        UpdateIosRequest request = new UpdateIosRequest(id, bundle, keyId, teamId, privateKeyBase64);
        this.logger.info("Calling push server to update iOS, ID: {} - start", (Object)id);
        Response response = (Response)this.putObjectImpl("/admin/app/ios/update", new ObjectRequest((Object)request));
        this.logger.info("Calling push server to update iOS, ID: {} - finish", (Object)id);
        return response;
    }

    public Response removeIos(Long id) throws PushServerClientException {
        RemoveIosRequest request = new RemoveIosRequest(id);
        this.logger.info("Calling push server to remove iOS, ID: {} - start", (Object)id);
        Response response = (Response)this.postObjectImpl("/admin/app/ios/remove", new ObjectRequest((Object)request));
        this.logger.info("Calling push server to remove iOS, ID: {} - finish", (Object)id);
        return response;
    }

    public Response updateAndroid(Long id, String projectId, byte[] privateKey) throws PushServerClientException {
        String privateKeyBase64 = BaseEncoding.base64().encode(privateKey);
        UpdateAndroidRequest request = new UpdateAndroidRequest(id, projectId, privateKeyBase64);
        this.logger.info("Calling push server to update android, ID: {} - start", (Object)id);
        Response response = (Response)this.putObjectImpl("/admin/app/android/update", new ObjectRequest((Object)request));
        this.logger.info("Calling push server to update android, ID: {} - finish", (Object)id);
        return response;
    }

    public Response removeAndroid(Long id) throws PushServerClientException {
        RemoveAndroidRequest request = new RemoveAndroidRequest(id);
        this.logger.info("Calling push server to remove android, ID: {} - start", (Object)id);
        Response response = (Response)this.postObjectImpl("/admin/app/android/remove", new ObjectRequest((Object)request));
        this.logger.info("Calling push server to remove android, ID: {} - finish", (Object)id);
        return response;
    }

    private <T> T getObjectImpl(String url, Map<String, Object> params, TypeReference typeReference) throws PushServerClientException {
        try {
            HttpResponse response = Unirest.get((String)(this.serviceBaseUrl + url)).header("Accept", "application/json").header("Content-Type", "application/json").queryString(params).asString();
            return this.checkHttpStatus(typeReference, response);
        }
        catch (UnirestException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
        }
        catch (JsonParseException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "JSON parsing has failed."));
        }
        catch (JsonMappingException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "JSON mapping has failed."));
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "Unknown IO error."));
        }
    }

    private <T> T postObjectImpl(String url, Object request) throws PushServerClientException {
        return this.postObjectImpl(url, request, (TypeReference)new TypeReference<Response>(){});
    }

    private <T> T postObjectImpl(String url, Object request, TypeReference typeReference) throws PushServerClientException {
        try {
            HttpResponse response = Unirest.post((String)(this.serviceBaseUrl + url)).header("Accept", "application/json").header("Content-Type", "application/json").body(request).asString();
            return this.checkHttpStatus(typeReference, response);
        }
        catch (UnirestException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
        }
        catch (JsonParseException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "JSON parsing has failed."));
        }
        catch (JsonMappingException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "JSON mapping has failed."));
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "Unknown IO error."));
        }
    }

    private <T> T putObjectImpl(String url, Object request) throws PushServerClientException {
        return this.putObjectImpl(url, request, (TypeReference)new TypeReference<Response>(){});
    }

    private <T> T putObjectImpl(String url, Object request, TypeReference typeReference) throws PushServerClientException {
        try {
            HttpResponse response = Unirest.put((String)(this.serviceBaseUrl + url)).header("Accept", "application/json").header("Content-Type", "application/json").body(request).asString();
            return this.checkHttpStatus(typeReference, response);
        }
        catch (UnirestException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
        }
        catch (JsonParseException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "JSON parsing has failed."));
        }
        catch (JsonMappingException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "JSON mapping has failed."));
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new PushServerClientException(e, new Error("PUSH_SERVER_CLIENT_ERROR", "Unknown IO error."));
        }
    }

    private <T> T checkHttpStatus(TypeReference typeReference, HttpResponse response) throws IOException, PushServerClientException {
        if (response.getStatus() == 200) {
            return (T)this.jacksonObjectMapper.readValue(response.getRawBody(), typeReference);
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            ErrorResponse errorResponse = (ErrorResponse)mapper.readValue(response.getRawBody(), ErrorResponse.class);
            throw new PushServerClientException("Error HTTP response status code received: " + response.getStatus(), (Error)errorResponse.getResponseObject());
        }
        catch (IOException ex) {
            this.logger.warn(ex.getMessage(), (Throwable)ex);
            throw new PushServerClientException("Error HTTP response status code received: " + response.getStatus());
        }
    }
}

