/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.push.client;

import com.google.common.io.BaseEncoding;
import com.wultra.core.rest.client.base.DefaultRestClient;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.entity.Error;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.push.client.PushServerClientException;
import io.getlime.push.model.base.PagedResponse;
import io.getlime.push.model.entity.ListOfUsers;
import io.getlime.push.model.entity.PushMessage;
import io.getlime.push.model.entity.PushMessageBody;
import io.getlime.push.model.entity.PushMessageSendResult;
import io.getlime.push.model.enumeration.MobilePlatform;
import io.getlime.push.model.request.CreateApplicationRequest;
import io.getlime.push.model.request.CreateCampaignRequest;
import io.getlime.push.model.request.CreateDeviceForActivationsRequest;
import io.getlime.push.model.request.CreateDeviceRequest;
import io.getlime.push.model.request.DeleteDeviceRequest;
import io.getlime.push.model.request.GetApplicationDetailRequest;
import io.getlime.push.model.request.RemoveAndroidRequest;
import io.getlime.push.model.request.RemoveIosRequest;
import io.getlime.push.model.request.SendPushMessageBatchRequest;
import io.getlime.push.model.request.SendPushMessageRequest;
import io.getlime.push.model.request.TestCampaignRequest;
import io.getlime.push.model.request.UpdateAndroidRequest;
import io.getlime.push.model.request.UpdateDeviceStatusRequest;
import io.getlime.push.model.request.UpdateIosRequest;
import io.getlime.push.model.response.CampaignResponse;
import io.getlime.push.model.response.CreateApplicationResponse;
import io.getlime.push.model.response.CreateCampaignResponse;
import io.getlime.push.model.response.DeleteCampaignResponse;
import io.getlime.push.model.response.GetApplicationDetailResponse;
import io.getlime.push.model.response.GetApplicationListResponse;
import io.getlime.push.model.response.ListOfCampaignsResponse;
import io.getlime.push.model.response.ListOfUsersFromCampaignResponse;
import io.getlime.push.model.response.ServiceStatusResponse;
import io.getlime.push.model.validator.CreateCampaignRequestValidator;
import io.getlime.push.model.validator.CreateDeviceRequestValidator;
import io.getlime.push.model.validator.DeleteDeviceRequestValidator;
import io.getlime.push.model.validator.SendPushMessageBatchRequestValidator;
import io.getlime.push.model.validator.SendPushMessageRequestValidator;
import io.getlime.push.model.validator.TestCampaignRequestValidator;
import io.getlime.push.model.validator.UpdateDeviceStatusRequestValidator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class PushServerClient {
    private static final Logger logger = LoggerFactory.getLogger(PushServerClient.class);
    private final RestClient restClient;

    public PushServerClient(String serviceBaseUrl) throws PushServerClientException {
        try {
            this.restClient = DefaultRestClient.builder().baseUrl(serviceBaseUrl).build();
        }
        catch (RestClientException ex) {
            throw new PushServerClientException("Rest client initialization failed, error: " + ex.getMessage());
        }
    }

    public ObjectResponse<ServiceStatusResponse> getServiceStatus() throws PushServerClientException {
        logger.info("Calling push server status service - start");
        ObjectResponse<ServiceStatusResponse> result = this.getObjectImpl("/push/service/status", null, ServiceStatusResponse.class);
        logger.info("Calling push server status service - finish");
        return result;
    }

    public boolean createDevice(String appId, String token, MobilePlatform platform) throws PushServerClientException {
        return this.createDevice(appId, token, platform, null);
    }

    public boolean createDevice(String appId, String token, MobilePlatform platform, String activationId) throws PushServerClientException {
        CreateDeviceRequest request = new CreateDeviceRequest();
        request.setAppId(appId);
        request.setToken(token);
        request.setPlatform(platform.value());
        request.setActivationId(activationId);
        String error = CreateDeviceRequestValidator.validate((CreateDeviceRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        logger.info("Calling create device service, appId: {}, token: {}, platform: {} - start", new Object[]{appId, this.maskToken(token), platform.value()});
        Response response = this.postObjectImpl("/push/device/create", new ObjectRequest((Object)request));
        logger.info("Calling create device service, appId: {}, token: {}, platform: {} - finish", new Object[]{appId, this.maskToken(token), platform.value()});
        return response.getStatus().equals("OK");
    }

    public boolean createDeviceForActivations(String appId, String token, MobilePlatform platform, List<String> activationIds) throws PushServerClientException {
        CreateDeviceForActivationsRequest request = new CreateDeviceForActivationsRequest();
        request.setAppId(appId);
        request.setToken(token);
        request.setPlatform(platform.value());
        request.getActivationIds().addAll(activationIds);
        String error = CreateDeviceRequestValidator.validate((CreateDeviceForActivationsRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        logger.info("Calling create device service, appId: {}, token: {}, platform: {} - start", new Object[]{appId, this.maskToken(token), platform.value()});
        Response response = this.postObjectImpl("/push/device/create/multi", new ObjectRequest((Object)request));
        logger.info("Calling create device service, appId: {}, token: {}, platform: {} - finish", new Object[]{appId, this.maskToken(token), platform.value()});
        return response.getStatus().equals("OK");
    }

    public boolean deleteDevice(String appId, String token) throws PushServerClientException {
        DeleteDeviceRequest request = new DeleteDeviceRequest();
        request.setAppId(appId);
        request.setToken(token);
        String error = DeleteDeviceRequestValidator.validate((DeleteDeviceRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        logger.info("Calling push server delete device service, appId: {}, token: {} - start", (Object)appId, (Object)this.maskToken(token));
        Response response = this.postObjectImpl("/push/device/delete", new ObjectRequest((Object)request));
        logger.info("Calling push server delete device service, appId: {}, token: {} - finish", (Object)appId, (Object)this.maskToken(token));
        return response.getStatus().equals("OK");
    }

    public boolean updateDeviceStatus(String activationId) throws PushServerClientException {
        UpdateDeviceStatusRequest request = new UpdateDeviceStatusRequest();
        request.setActivationId(activationId);
        String error = UpdateDeviceStatusRequestValidator.validate((UpdateDeviceStatusRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        logger.info("Calling push server update device status, activation ID: {} - start", (Object)activationId);
        Response response = this.postImpl("/push/device/status/update", request, new ParameterizedTypeReference<Response>(){});
        logger.info("Calling push server update device status, activation ID: {} - finish", (Object)activationId);
        return response.getStatus().equals("OK");
    }

    public ObjectResponse<PushMessageSendResult> sendPushMessage(String appId, PushMessage pushMessage) throws PushServerClientException {
        SendPushMessageRequest request = new SendPushMessageRequest();
        request.setAppId(appId);
        request.setMessage(pushMessage);
        String error = SendPushMessageRequestValidator.validate((SendPushMessageRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        logger.info("Calling push server to send a push message, app ID: {}, user ID: {} - start", (Object)appId, (Object)pushMessage.getUserId());
        ObjectResponse<PushMessageSendResult> result = this.postObjectImpl("/push/message/send", new ObjectRequest((Object)request), PushMessageSendResult.class);
        logger.info("Calling push server to send a push message, app ID: {}, user ID: {} - finish", (Object)appId, (Object)pushMessage.getUserId());
        return result;
    }

    public ObjectResponse<PushMessageSendResult> sendPushMessageBatch(String appId, List<PushMessage> batch) throws PushServerClientException {
        SendPushMessageBatchRequest request = new SendPushMessageBatchRequest();
        request.setAppId(appId);
        request.setBatch(batch);
        String error = SendPushMessageBatchRequestValidator.validate((SendPushMessageBatchRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        logger.info("Calling push server to send a push message batch, app ID: {} - start", (Object)appId);
        ObjectResponse<PushMessageSendResult> result = this.postObjectImpl("/push/message/batch/send", new ObjectRequest((Object)request), PushMessageSendResult.class);
        logger.info("Calling push server to send a push message batch, app ID: {} - finish", (Object)appId);
        return result;
    }

    public ObjectResponse<CreateCampaignResponse> createCampaign(String appId, PushMessageBody message) throws PushServerClientException {
        CreateCampaignRequest request = new CreateCampaignRequest();
        request.setAppId(appId);
        request.setMessage(message);
        String error = CreateCampaignRequestValidator.validate((CreateCampaignRequest)request);
        if (error != null) {
            throw new PushServerClientException(error);
        }
        logger.info("Calling push server to create a push campaign, app ID: {} - start", (Object)appId);
        ObjectResponse<CreateCampaignResponse> result = this.postObjectImpl("/push/campaign/create", new ObjectRequest((Object)request), CreateCampaignResponse.class);
        logger.info("Calling push server to create a push campaign, app ID: {} - finish", (Object)appId);
        return result;
    }

    public boolean deleteCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            logger.info("Calling push server to delete a push campaign, campaign ID: {} - start", (Object)campaignId);
            ObjectResponse<DeleteCampaignResponse> response = this.postObjectImpl("/push/campaign/" + campaignIdSanitized + "/delete", null, DeleteCampaignResponse.class);
            logger.info("Calling push server to delete a push campaign, campaign ID: {} - finish", (Object)campaignId);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public ObjectResponse<ListOfCampaignsResponse> getListOfCampaigns(boolean all) throws PushServerClientException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.put((Object)"all", Collections.singletonList(Boolean.valueOf(all).toString()));
        logger.info("Calling push server to obtain a push campaign list - start");
        ObjectResponse<ListOfCampaignsResponse> result = this.getObjectImpl("/push/campaign/list", (MultiValueMap<String, String>)params, ListOfCampaignsResponse.class);
        logger.info("Calling push server to obtain a push campaign list - finish");
        return result;
    }

    public ObjectResponse<CampaignResponse> getCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            logger.info("Calling push server to obtain a push campaign detail, campaign ID: {} - start", (Object)campaignId);
            ObjectResponse<CampaignResponse> result = this.getObjectImpl("/push/campaign/" + campaignIdSanitized + "/detail", null, CampaignResponse.class);
            logger.info("Calling push server to obtain a push campaign detail, campaign ID: {} - finish", (Object)campaignId);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean addUsersToCampaign(Long campaignId, List<String> users) throws PushServerClientException {
        try {
            ListOfUsers listOfUsers = new ListOfUsers(users);
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            logger.info("Calling push server to add users to campaign, campaign ID: {} - start", (Object)campaignId);
            Response response = this.putObjectImpl("/push/campaign/" + campaignIdSanitized + "/user/add", new ObjectRequest((Object)listOfUsers));
            logger.info("Calling push server to add users to campaign, campaign ID: {} - finish", (Object)campaignId);
            if (response == null) {
                throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", "Network communication has failed."));
            }
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public PagedResponse<ListOfUsersFromCampaignResponse> getListOfUsersFromCampaign(Long campaignId, int page, int size) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.put((Object)"page", Collections.singletonList(Integer.valueOf(page).toString()));
            params.put((Object)"size", Collections.singletonList(Integer.valueOf(size).toString()));
            ParameterizedTypeReference<PagedResponse<ListOfUsersFromCampaignResponse>> typeReference = new ParameterizedTypeReference<PagedResponse<ListOfUsersFromCampaignResponse>>(){};
            logger.info("Calling push server to get users from the campaign, campaign ID: {} - start", (Object)campaignId);
            PagedResponse<ListOfUsersFromCampaignResponse> result = this.getImpl("/push/campaign/" + campaignIdSanitized + "/user/list", (MultiValueMap<String, String>)params, typeReference);
            logger.info("Calling push server to get users from the campaign, campaign ID: {} - finish", (Object)campaignId);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean deleteUsersFromCampaign(Long campaignId, List<String> users) throws PushServerClientException {
        try {
            ListOfUsers listOfUsers = new ListOfUsers(users);
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            logger.info("Calling push server to remove users from the campaign, campaign ID: {} - start", (Object)campaignId);
            Response response = this.postObjectImpl("/push/campaign/" + campaignIdSanitized + "/user/delete", new ObjectRequest((Object)listOfUsers));
            logger.info("Calling push server to remove users from the campaign, campaign ID: {} - finish", (Object)campaignId);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean sendTestCampaign(Long campaignId, String userId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            TestCampaignRequest request = new TestCampaignRequest();
            request.setUserId(userId);
            String error = TestCampaignRequestValidator.validate((TestCampaignRequest)request);
            if (error != null) {
                throw new PushServerClientException(error);
            }
            logger.info("Calling push server to send test campaign, campaign ID: {}, user ID: {} - start", (Object)campaignId, (Object)userId);
            Response response = this.postObjectImpl("/push/campaign/send/test/" + campaignIdSanitized, new ObjectRequest((Object)request));
            logger.info("Calling push server to send test campaign, campaign ID: {}, user ID: {} - finish", (Object)campaignId, (Object)userId);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public boolean sendCampaign(Long campaignId) throws PushServerClientException {
        try {
            String campaignIdSanitized = URLEncoder.encode(String.valueOf(campaignId), "UTF-8");
            logger.info("Calling push server to send a production campaign, campaign ID: {} - start", (Object)campaignId);
            Response response = this.postObjectImpl("/push/campaign/send/live/" + campaignIdSanitized, null);
            logger.info("Calling push server to send a production campaign, campaign ID: {} - finish", (Object)campaignId);
            return response.getStatus().equals("OK");
        }
        catch (UnsupportedEncodingException e) {
            throw new PushServerClientException(new Error("PUSH_SERVER_CLIENT_ERROR", e.getMessage()));
        }
    }

    public ObjectResponse<GetApplicationListResponse> getApplicationList() throws PushServerClientException {
        logger.info("Calling push server to retrieve list of applications - start");
        ObjectResponse<GetApplicationListResponse> response = this.getObjectImpl("/admin/app/list", null, GetApplicationListResponse.class);
        logger.info("Calling push server to retrieve list of applications - finish");
        return response;
    }

    public ObjectResponse<GetApplicationListResponse> getUnconfiguredApplicationList() throws PushServerClientException {
        logger.info("Calling push server to retrieve list of unconfigured applications - start");
        ObjectResponse<GetApplicationListResponse> response = this.getObjectImpl("/admin/app/unconfigured/list", null, GetApplicationListResponse.class);
        logger.info("Calling push server to retrieve list of unconfigured applications - finish");
        return response;
    }

    public ObjectResponse<GetApplicationDetailResponse> getApplicationDetail(String appId, boolean includeIos, boolean includeAndroid) throws PushServerClientException {
        GetApplicationDetailRequest request = new GetApplicationDetailRequest(appId, includeIos, includeAndroid);
        logger.info("Calling push server to retrieve application detail, ID: {} - start", (Object)appId);
        ObjectResponse<GetApplicationDetailResponse> response = this.postObjectImpl("/admin/app/detail", new ObjectRequest((Object)request), GetApplicationDetailResponse.class);
        logger.info("Calling push server to retrieve application detail, ID: {} - finish", (Object)appId);
        return response;
    }

    public ObjectResponse<CreateApplicationResponse> createApplication(String appId) throws PushServerClientException {
        CreateApplicationRequest request = new CreateApplicationRequest(appId);
        logger.info("Calling push server to create application, app ID: {} - start", (Object)appId);
        ObjectResponse<CreateApplicationResponse> response = this.postObjectImpl("/admin/app/create", new ObjectRequest((Object)request), CreateApplicationResponse.class);
        logger.info("Calling push server to create application, app ID: {} - finish", (Object)appId);
        return response;
    }

    public Response updateIos(String appId, String bundle, String keyId, String teamId, String environment, byte[] privateKey) throws PushServerClientException {
        String privateKeyBase64 = BaseEncoding.base64().encode(privateKey);
        UpdateIosRequest request = new UpdateIosRequest(appId, bundle, keyId, teamId, environment, privateKeyBase64);
        logger.info("Calling push server to update iOS, ID: {} - start", (Object)appId);
        Response response = this.putObjectImpl("/admin/app/ios/update", new ObjectRequest((Object)request));
        logger.info("Calling push server to update iOS, ID: {} - finish", (Object)appId);
        return response;
    }

    public Response removeIos(String appId) throws PushServerClientException {
        RemoveIosRequest request = new RemoveIosRequest(appId);
        logger.info("Calling push server to remove iOS, ID: {} - start", (Object)appId);
        Response response = this.postObjectImpl("/admin/app/ios/remove", new ObjectRequest((Object)request));
        logger.info("Calling push server to remove iOS, ID: {} - finish", (Object)appId);
        return response;
    }

    public Response updateAndroid(String appId, String projectId, byte[] privateKey) throws PushServerClientException {
        String privateKeyBase64 = BaseEncoding.base64().encode(privateKey);
        UpdateAndroidRequest request = new UpdateAndroidRequest(appId, projectId, privateKeyBase64);
        logger.info("Calling push server to update android, ID: {} - start", (Object)appId);
        Response response = this.putObjectImpl("/admin/app/android/update", new ObjectRequest((Object)request));
        logger.info("Calling push server to update android, ID: {} - finish", (Object)appId);
        return response;
    }

    public Response removeAndroid(String appId) throws PushServerClientException {
        RemoveAndroidRequest request = new RemoveAndroidRequest(appId);
        logger.info("Calling push server to remove android, ID: {} - start", (Object)appId);
        Response response = this.postObjectImpl("/admin/app/android/remove", new ObjectRequest((Object)request));
        logger.info("Calling push server to remove android, ID: {} - finish", (Object)appId);
        return response;
    }

    private <T> T getImpl(String url, MultiValueMap<String, String> params, ParameterizedTypeReference<T> typeReference) throws PushServerClientException {
        try {
            return (T)this.restClient.get(url, params, null, typeReference).getBody();
        }
        catch (RestClientException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new PushServerClientException(ex, new Error("PUSH_SERVER_CLIENT_ERROR", "HTTP GET request failed."));
        }
    }

    private <T> ObjectResponse<T> getObjectImpl(String url, MultiValueMap<String, String> params, Class<T> responseType) throws PushServerClientException {
        try {
            return this.restClient.getObject(url, params, null, responseType);
        }
        catch (RestClientException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new PushServerClientException(ex, new Error("PUSH_SERVER_CLIENT_ERROR", "HTTP GET request failed."));
        }
    }

    private <T> T postImpl(String url, Object request, ParameterizedTypeReference<T> typeReference) throws PushServerClientException {
        try {
            return (T)this.restClient.post(url, request, typeReference).getBody();
        }
        catch (RestClientException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new PushServerClientException(ex, new Error("PUSH_SERVER_CLIENT_ERROR", "HTTP POST request failed."));
        }
    }

    private Response postObjectImpl(String url, ObjectRequest<?> request) throws PushServerClientException {
        try {
            return this.restClient.postObject(url, request);
        }
        catch (RestClientException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new PushServerClientException(ex, new Error("PUSH_SERVER_CLIENT_ERROR", "HTTP POST request failed."));
        }
    }

    private <T> ObjectResponse<T> postObjectImpl(String url, ObjectRequest<?> request, Class<T> responseType) throws PushServerClientException {
        try {
            return this.restClient.postObject(url, request, responseType);
        }
        catch (RestClientException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new PushServerClientException(ex, new Error("PUSH_SERVER_CLIENT_ERROR", "HTTP POST request failed."));
        }
    }

    private Response putObjectImpl(String url, ObjectRequest<?> request) throws PushServerClientException {
        try {
            return this.restClient.putObject(url, request);
        }
        catch (RestClientException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            throw new PushServerClientException(ex, new Error("PUSH_SERVER_CLIENT_ERROR", "HTTP POST request failed."));
        }
    }

    private String maskToken(String token) {
        if (token == null || token.length() < 10) {
            return token;
        }
        return token.substring(0, 10) + "...";
    }
}

