/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.rest.api.security.filter;

import com.google.common.primitives.Bytes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ResettableStreamHttpServletRequest
extends HttpServletRequestWrapper {
    private byte[] requestBody = new byte[0];
    private boolean bufferFilled = false;

    public ResettableStreamHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public byte[] getRequestBody() throws IOException {
        int bytesRead;
        if (this.bufferFilled) {
            return Arrays.copyOf(this.requestBody, this.requestBody.length);
        }
        ServletInputStream inputStream = super.getInputStream();
        byte[] buffer = new byte[102400];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.requestBody = Bytes.concat((byte[][])new byte[][]{this.requestBody, Arrays.copyOfRange(buffer, 0, bytesRead)});
        }
        this.bufferFilled = true;
        return this.requestBody;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new CustomServletInputStream(this.getRequestBody());
    }

    private static class CustomServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream buffer;

        public CustomServletInputStream(byte[] contents) {
            this.buffer = new ByteArrayInputStream(contents);
        }

        public int read() throws IOException {
            return this.buffer.read();
        }

        public boolean isFinished() {
            return this.buffer.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener arg0) {
            throw new RuntimeException("Not implemented");
        }
    }
}

