/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.rest.api.security.provider;

import com.google.common.io.BaseEncoding;
import io.getlime.rest.api.security.authentication.PowerAuthApiAuthenticationBase;
import io.getlime.rest.api.security.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.lib.enums.PowerAuthSignatureTypes;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public abstract class PowerAuthAuthenticationProviderBase {
    public abstract PowerAuthApiAuthenticationBase validateRequestSignature(String var1, byte[] var2, String var3, String var4, List<PowerAuthSignatureTypes> var5) throws PowerAuthAuthenticationException;

    public PowerAuthApiAuthenticationBase validateRequestSignature(String httpMethod, byte[] httpBody, String requestUriIdentifier, String httpAuthorizationHeader) throws PowerAuthAuthenticationException {
        ArrayList<PowerAuthSignatureTypes> defaultAllowedSignatureTypes = new ArrayList<PowerAuthSignatureTypes>();
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_BIOMETRY);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY);
        return this.validateRequestSignature(httpMethod, httpBody, requestUriIdentifier, httpAuthorizationHeader, defaultAllowedSignatureTypes);
    }

    public PowerAuthApiAuthenticationBase validateRequestSignature(HttpServletRequest servletRequest, String requestUriIdentifier, String httpAuthorizationHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        String requestMethod = servletRequest.getMethod().toUpperCase();
        String requestBodyString = (String)servletRequest.getAttribute("X-PowerAuth-Request-Body");
        byte[] requestBodyBytes = requestBodyString == null ? null : BaseEncoding.base64().decode((CharSequence)requestBodyString);
        return this.validateRequestSignature(requestMethod, requestBodyBytes, requestUriIdentifier, httpAuthorizationHeader, allowedSignatureTypes);
    }

    public PowerAuthApiAuthenticationBase validateRequestSignature(HttpServletRequest servletRequest, String requestUriIdentifier, String httpAuthorizationHeader) throws PowerAuthAuthenticationException {
        ArrayList<PowerAuthSignatureTypes> defaultAllowedSignatureTypes = new ArrayList<PowerAuthSignatureTypes>();
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_BIOMETRY);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY);
        return this.validateRequestSignature(servletRequest, requestUriIdentifier, httpAuthorizationHeader, defaultAllowedSignatureTypes);
    }
}

