/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.rest.api.security.filter;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ResettableStreamHttpServletRequest
extends HttpServletRequestWrapper {
    private byte[] requestBody = new byte[0];
    private boolean bufferFilled = false;

    public ResettableStreamHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public byte[] getRequestBody() throws IOException {
        if (this.bufferFilled) {
            return Arrays.copyOf(this.requestBody, this.requestBody.length);
        }
        ServletInputStream inputStream = super.getInputStream();
        this.requestBody = ByteStreams.toByteArray((InputStream)inputStream);
        this.bufferFilled = true;
        return this.requestBody;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new CustomServletInputStream(this.getRequestBody());
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private static class CustomServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream buffer;

        public CustomServletInputStream(byte[] contents) {
            this.buffer = new ByteArrayInputStream(contents);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.buffer.read(b, off, len);
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            int c;
            if (len <= 0) {
                return 0;
            }
            int count = 0;
            while ((c = this.buffer.read()) != -1) {
                b[off++] = (byte)c;
                if (c != 10 && ++count != len) continue;
            }
            return count > 0 ? count : -1;
        }

        public int read() throws IOException {
            return this.buffer.read();
        }

        public int read(byte[] b) throws IOException {
            return this.buffer.read(b);
        }

        public boolean isFinished() {
            return this.buffer.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener arg0) {
            throw new RuntimeException("Not implemented");
        }
    }
}

