/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.base.filter;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.http.PowerAuthRequestCanonizationUtils;
import io.getlime.security.powerauth.rest.api.base.filter.ResettableStreamHttpServletRequest;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class PowerAuthRequestFilterBase {
    public static final String POWERAUTH_SIGNATURE_BASE_STRING = "X-PowerAuth-Request-Body";

    public static ResettableStreamHttpServletRequest filterRequest(HttpServletRequest httpRequest) throws IOException {
        ResettableStreamHttpServletRequest resettableRequest = new ResettableStreamHttpServletRequest(httpRequest);
        if (httpRequest.getMethod().toUpperCase().equals("GET")) {
            String signatureBaseStringData;
            String queryString = httpRequest.getQueryString();
            if (queryString != null && queryString.length() > 0 && (signatureBaseStringData = PowerAuthRequestCanonizationUtils.canonizeGetParameters((String)queryString)) != null) {
                resettableRequest.setAttribute(POWERAUTH_SIGNATURE_BASE_STRING, BaseEncoding.base64().encode(signatureBaseStringData.getBytes("UTF-8")));
            }
        } else {
            byte[] body = resettableRequest.getRequestBody();
            if (body != null) {
                resettableRequest.setAttribute(POWERAUTH_SIGNATURE_BASE_STRING, BaseEncoding.base64().encode(body));
            }
        }
        return resettableRequest;
    }
}

