/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.base.provider;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public abstract class PowerAuthAuthenticationProviderBase {
    public abstract PowerAuthApiAuthentication validateRequestSignature(String var1, byte[] var2, String var3, String var4, List<PowerAuthSignatureTypes> var5) throws PowerAuthAuthenticationException;

    public PowerAuthApiAuthentication validateRequestSignature(String httpMethod, byte[] httpBody, String requestUriIdentifier, String httpAuthorizationHeader) throws PowerAuthAuthenticationException {
        ArrayList<PowerAuthSignatureTypes> defaultAllowedSignatureTypes = new ArrayList<PowerAuthSignatureTypes>();
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_BIOMETRY);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY);
        return this.validateRequestSignature(httpMethod, httpBody, requestUriIdentifier, httpAuthorizationHeader, defaultAllowedSignatureTypes);
    }

    public PowerAuthApiAuthentication validateRequestSignature(HttpServletRequest servletRequest, String requestUriIdentifier, String httpAuthorizationHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        String requestMethod = servletRequest.getMethod().toUpperCase();
        String requestBodyString = (String)servletRequest.getAttribute("X-PowerAuth-Request-Body");
        byte[] requestBodyBytes = requestBodyString == null ? null : BaseEncoding.base64().decode((CharSequence)requestBodyString);
        return this.validateRequestSignature(requestMethod, requestBodyBytes, requestUriIdentifier, httpAuthorizationHeader, allowedSignatureTypes);
    }

    public PowerAuthApiAuthentication validateRequestSignature(HttpServletRequest servletRequest, String requestUriIdentifier, String httpAuthorizationHeader) throws PowerAuthAuthenticationException {
        ArrayList<PowerAuthSignatureTypes> defaultAllowedSignatureTypes = new ArrayList<PowerAuthSignatureTypes>();
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_BIOMETRY);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY);
        return this.validateRequestSignature(servletRequest, requestUriIdentifier, httpAuthorizationHeader, defaultAllowedSignatureTypes);
    }
}

