/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.base.provider;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.encryption.PowerAuthEciesEncryption;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.model.PowerAuthRequestBody;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public abstract class PowerAuthAuthenticationProviderBase {
    public abstract PowerAuthApiAuthentication validateRequestSignature(String var1, byte[] var2, String var3, String var4, List<PowerAuthSignatureTypes> var5, @Nullable Integer var6) throws PowerAuthAuthenticationException;

    public abstract PowerAuthApiAuthentication validateToken(String var1, List<PowerAuthSignatureTypes> var2) throws PowerAuthAuthenticationException;

    public PowerAuthApiAuthentication validateRequestSignature(String httpMethod, byte[] httpBody, String requestUriIdentifier, String httpAuthorizationHeader) throws PowerAuthAuthenticationException {
        ArrayList<PowerAuthSignatureTypes> defaultAllowedSignatureTypes = new ArrayList<PowerAuthSignatureTypes>();
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_BIOMETRY);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY);
        return this.validateRequestSignature(httpMethod, httpBody, requestUriIdentifier, httpAuthorizationHeader, defaultAllowedSignatureTypes, null);
    }

    public PowerAuthApiAuthentication validateRequestSignature(HttpServletRequest servletRequest, String requestUriIdentifier, String httpAuthorizationHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        String requestMethod = servletRequest.getMethod().toUpperCase();
        byte[] requestBodyBytes = this.extractRequestBodyBytes(servletRequest);
        return this.validateRequestSignature(requestMethod, requestBodyBytes, requestUriIdentifier, httpAuthorizationHeader, allowedSignatureTypes, null);
    }

    public PowerAuthApiAuthentication validateRequestSignature(HttpServletRequest servletRequest, String requestUriIdentifier, String httpAuthorizationHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes, @Nullable Integer forcedSignatureVersion) throws PowerAuthAuthenticationException {
        String requestMethod = servletRequest.getMethod().toUpperCase();
        byte[] requestBodyBytes = this.extractRequestBodyBytes(servletRequest);
        return this.validateRequestSignature(requestMethod, requestBodyBytes, requestUriIdentifier, httpAuthorizationHeader, allowedSignatureTypes, forcedSignatureVersion);
    }

    public PowerAuthApiAuthentication validateRequestSignature(HttpServletRequest servletRequest, String requestUriIdentifier, String httpAuthorizationHeader) throws PowerAuthAuthenticationException {
        ArrayList<PowerAuthSignatureTypes> defaultAllowedSignatureTypes = new ArrayList<PowerAuthSignatureTypes>();
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_BIOMETRY);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY);
        return this.validateRequestSignature(servletRequest, requestUriIdentifier, httpAuthorizationHeader, defaultAllowedSignatureTypes, null);
    }

    public PowerAuthApiAuthentication validateToken(String tokenHeader) throws PowerAuthAuthenticationException {
        ArrayList<PowerAuthSignatureTypes> defaultAllowedSignatureTypes = new ArrayList<PowerAuthSignatureTypes>();
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_BIOMETRY);
        defaultAllowedSignatureTypes.add(PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY);
        return this.validateToken(tokenHeader, defaultAllowedSignatureTypes);
    }

    public byte[] extractRequestBodyBytes(HttpServletRequest servletRequest) throws PowerAuthAuthenticationException {
        if (servletRequest.getAttribute("X-PowerAuth-Encryption-Object") != null) {
            PowerAuthEciesEncryption eciesEncryption = (PowerAuthEciesEncryption)servletRequest.getAttribute("X-PowerAuth-Encryption-Object");
            return eciesEncryption.getDecryptedRequest();
        }
        PowerAuthRequestBody requestBody = (PowerAuthRequestBody)servletRequest.getAttribute("X-PowerAuth-Request-Body");
        if (requestBody == null) {
            throw new PowerAuthAuthenticationException("The X-PowerAuth-Request-Body request attribute is missing, register the PowerAuthRequestFilter to fix this error");
        }
        return requestBody.getRequestBytes();
    }
}

