/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.base.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesDecryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEnvelopeKey;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesScope;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthEncryptionHttpHeaderValidator;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.encryption.EciesEncryptionContext;
import io.getlime.security.powerauth.rest.api.base.encryption.PowerAuthEciesDecryptorParameters;
import io.getlime.security.powerauth.rest.api.base.encryption.PowerAuthEciesEncryption;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.base.model.PowerAuthRequestBody;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public abstract class PowerAuthEncryptionProviderBase {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final EciesFactory eciesFactory = new EciesFactory();

    public abstract PowerAuthEciesDecryptorParameters getEciesDecryptorParameters(String var1, String var2, String var3) throws PowerAuthEncryptionException;

    public <T> PowerAuthEciesEncryption<T> decryptRequest(HttpServletRequest request, Class<T> requestType, EciesScope eciesScope) throws PowerAuthEncryptionException {
        if (!"POST".equals(request.getMethod())) {
            throw new PowerAuthEncryptionException("Invalid HTTP request");
        }
        EciesEncryptionContext encryptionContext = this.extractEciesEncryptionContext(request);
        PowerAuthEciesEncryption<T> eciesEncryption = new PowerAuthEciesEncryption<T>(encryptionContext);
        eciesEncryption.getContext().setEciesScope(eciesScope);
        try {
            PowerAuthEciesDecryptorParameters decryptorParameters;
            PowerAuthRequestBody requestBody = (PowerAuthRequestBody)request.getAttribute("X-PowerAuth-Request-Body");
            if (requestBody == null) {
                throw new PowerAuthEncryptionException("The X-PowerAuth-Request-Body request attribute is missing, register the PowerAuthRequestFilter to fix this error");
            }
            byte[] requestBodyBytes = requestBody.getRequestBytes();
            if (requestBodyBytes == null || requestBodyBytes.length == 0) {
                throw new PowerAuthEncryptionException("Invalid HTTP request");
            }
            EciesEncryptedRequest eciesRequest = (EciesEncryptedRequest)this.objectMapper.readValue(requestBodyBytes, EciesEncryptedRequest.class);
            if (eciesRequest == null) {
                throw new PowerAuthEncryptionException("Invalid ECIES request data");
            }
            String ephemeralPublicKey = eciesRequest.getEphemeralPublicKey();
            String encryptedData = eciesRequest.getEncryptedData();
            String mac = eciesRequest.getMac();
            String nonce = eciesRequest.getNonce();
            if (ephemeralPublicKey == null || encryptedData == null || mac == null) {
                throw new PowerAuthEncryptionException("Invalid ECIES request data");
            }
            if (nonce == null && !"3.0".equals(encryptionContext.getVersion())) {
                throw new PowerAuthEncryptionException("Missing nonce in ECIES request data");
            }
            byte[] ephemeralPublicKeyBytes = BaseEncoding.base64().decode((CharSequence)ephemeralPublicKey);
            byte[] encryptedDataBytes = BaseEncoding.base64().decode((CharSequence)encryptedData);
            byte[] macBytes = BaseEncoding.base64().decode((CharSequence)mac);
            byte[] nonceBytes = nonce != null ? BaseEncoding.base64().decode((CharSequence)nonce) : null;
            String applicationKey = eciesEncryption.getContext().getApplicationKey();
            switch (eciesScope) {
                case ACTIVATION_SCOPE: {
                    String activationId = eciesEncryption.getContext().getActivationId();
                    if (activationId == null) {
                        throw new PowerAuthEncryptionException("Activation ID is required in ECIES activation scope");
                    }
                    decryptorParameters = this.getEciesDecryptorParameters(activationId, applicationKey, ephemeralPublicKey);
                    break;
                }
                case APPLICATION_SCOPE: {
                    decryptorParameters = this.getEciesDecryptorParameters(null, applicationKey, ephemeralPublicKey);
                    break;
                }
                default: {
                    throw new PowerAuthEncryptionException("Unsupported ECIES scope: " + eciesScope);
                }
            }
            byte[] secretKey = BaseEncoding.base64().decode((CharSequence)decryptorParameters.getSecretKey());
            EciesEnvelopeKey envelopeKey = new EciesEnvelopeKey(secretKey, ephemeralPublicKeyBytes);
            byte[] sharedInfo2 = BaseEncoding.base64().decode((CharSequence)decryptorParameters.getSharedInfo2());
            EciesDecryptor eciesDecryptor = this.eciesFactory.getEciesDecryptor(envelopeKey, sharedInfo2);
            eciesEncryption.setEciesDecryptor(eciesDecryptor);
            EciesCryptogram cryptogram = new EciesCryptogram(ephemeralPublicKeyBytes, macBytes, encryptedDataBytes, nonceBytes);
            byte[] decryptedData = eciesDecryptor.decryptRequest(cryptogram);
            eciesEncryption.setEncryptedRequest(encryptedDataBytes);
            eciesEncryption.setDecryptedRequest(decryptedData);
            if (decryptedData.length != 0) {
                eciesEncryption.setRequestObject(this.deserializeRequestData(decryptedData, requestType));
            }
            request.setAttribute("X-PowerAuth-Encryption-Object", eciesEncryption);
        }
        catch (Exception ex) {
            throw new PowerAuthEncryptionException("Invalid request");
        }
        return eciesEncryption;
    }

    public EciesEncryptedResponse encryptResponse(Object responseObject, PowerAuthEciesEncryption eciesEncryption) {
        try {
            byte[] responseData = this.serializeResponseData(responseObject);
            EciesCryptogram cryptogram = eciesEncryption.getEciesDecryptor().encryptResponse(responseData);
            String encryptedDataBase64 = BaseEncoding.base64().encode(cryptogram.getEncryptedData());
            String macBase64 = BaseEncoding.base64().encode(cryptogram.getMac());
            return new EciesEncryptedResponse(encryptedDataBase64, macBase64);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private <T> T deserializeRequestData(byte[] requestData, Class<T> requestType) throws IOException {
        if (requestType.equals(byte[].class)) {
            return (T)requestData;
        }
        return (T)this.objectMapper.readValue(requestData, requestType);
    }

    private byte[] serializeResponseData(Object responseObject) throws JsonProcessingException {
        if (responseObject.getClass().equals(byte[].class)) {
            return (byte[])responseObject;
        }
        return this.objectMapper.writeValueAsBytes(responseObject);
    }

    private EciesEncryptionContext extractEciesEncryptionContext(HttpServletRequest request) throws PowerAuthEncryptionException {
        String encryptionHttpHeader = request.getHeader("X-PowerAuth-Encryption");
        String signatureHttpHeader = request.getHeader("X-PowerAuth-Authorization");
        if (encryptionHttpHeader == null && signatureHttpHeader == null) {
            throw new PowerAuthEncryptionException("POWER_AUTH_ENCRYPTION_INVALID_HEADER");
        }
        if (signatureHttpHeader != null) {
            PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHttpHeader);
            try {
                PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
            }
            catch (InvalidPowerAuthHttpHeaderException e) {
                throw new PowerAuthEncryptionException(e.getMessage());
            }
            String applicationKey = header.getApplicationKey();
            String activationId = header.getActivationId();
            String version = header.getVersion();
            return new EciesEncryptionContext(applicationKey, activationId, version, (PowerAuthHttpHeader)header);
        }
        PowerAuthEncryptionHttpHeader header = new PowerAuthEncryptionHttpHeader().fromValue(encryptionHttpHeader);
        try {
            PowerAuthEncryptionHttpHeaderValidator.validate((PowerAuthEncryptionHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException e) {
            throw new PowerAuthEncryptionException(e.getMessage());
        }
        String applicationKey = header.getApplicationKey();
        String activationId = header.getActivationId();
        String version = header.getVersion();
        return new EciesEncryptionContext(applicationKey, activationId, version, (PowerAuthHttpHeader)header);
    }
}

