/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.provider;

import com.google.common.io.BaseEncoding;
import io.getlime.powerauth.soap.v3.SignatureType;
import io.getlime.powerauth.soap.v3.ValidateTokenRequest;
import io.getlime.powerauth.soap.v3.ValidateTokenResponse;
import io.getlime.powerauth.soap.v3.VerifySignatureRequest;
import io.getlime.powerauth.soap.v3.VerifySignatureResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthTokenHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.http.validator.PowerAuthTokenHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.application.PowerAuthApplicationConfiguration;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.provider.PowerAuthAuthenticationProviderBase;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthApiAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthSignatureAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthTokenAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.spring.converter.v3.SignatureTypeConverter;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class PowerAuthAuthenticationProvider
extends PowerAuthAuthenticationProviderBase
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthAuthenticationProvider.class);
    private PowerAuthServiceClient powerAuthClient;
    private PowerAuthApplicationConfiguration applicationConfiguration;

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @Autowired(required=false)
    public void setApplicationConfiguration(PowerAuthApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication instanceof PowerAuthSignatureAuthenticationImpl) {
            return this.validateSignatureAuthentication((PowerAuthSignatureAuthenticationImpl)authentication);
        }
        if (authentication instanceof PowerAuthTokenAuthenticationImpl) {
            return this.validateTokenAuthentication((PowerAuthTokenAuthenticationImpl)authentication);
        }
        return null;
    }

    private PowerAuthApiAuthenticationImpl validateSignatureAuthentication(PowerAuthSignatureAuthenticationImpl authentication) {
        if (authentication.getSignatureType() != null) {
            VerifySignatureResponse soapResponse;
            SignatureTypeConverter converter = new SignatureTypeConverter();
            SignatureType signatureType = converter.convertFrom(authentication.getSignatureType());
            VerifySignatureRequest soapRequest = new VerifySignatureRequest();
            soapRequest.setActivationId(authentication.getActivationId());
            soapRequest.setApplicationKey(authentication.getApplicationKey());
            soapRequest.setSignature(authentication.getSignature());
            soapRequest.setSignatureType(signatureType);
            soapRequest.setSignatureVersion(authentication.getVersion());
            soapRequest.setData(PowerAuthHttpBody.getSignatureBaseString((String)authentication.getHttpMethod(), (String)authentication.getRequestUri(), (byte[])authentication.getNonce(), (byte[])authentication.getData()));
            if (authentication.getForcedSignatureVersion() != null) {
                soapRequest.setForcedSignatureVersion(Long.valueOf(authentication.getForcedSignatureVersion().longValue()));
            }
            if ((soapResponse = this.powerAuthClient.verifySignature(soapRequest)).isSignatureValid()) {
                return this.copyAuthenticationAttributes(soapResponse.getActivationId(), soapResponse.getUserId(), soapResponse.getApplicationId(), PowerAuthSignatureTypes.getEnumFromString((String)soapResponse.getSignatureType().value()), authentication.getVersion(), authentication.getHttpHeader());
            }
            return null;
        }
        return null;
    }

    private PowerAuthApiAuthenticationImpl validateTokenAuthentication(PowerAuthTokenAuthenticationImpl authentication) {
        ValidateTokenRequest soapRequest = new ValidateTokenRequest();
        soapRequest.setTokenId(authentication.getTokenId());
        soapRequest.setTokenDigest(authentication.getTokenDigest());
        soapRequest.setNonce(authentication.getNonce());
        soapRequest.setTimestamp(Long.valueOf(authentication.getTimestamp()).longValue());
        try {
            ValidateTokenResponse soapResponse = this.powerAuthClient.validateToken(soapRequest);
            if (soapResponse.isTokenValid()) {
                return this.copyAuthenticationAttributes(soapResponse.getActivationId(), soapResponse.getUserId(), soapResponse.getApplicationId(), PowerAuthSignatureTypes.getEnumFromString((String)soapResponse.getSignatureType().value()), authentication.getVersion(), authentication.getHttpHeader());
            }
            return null;
        }
        catch (Exception e) {
            logger.warn("Token validation failed", (Throwable)e);
            return null;
        }
    }

    private PowerAuthApiAuthenticationImpl copyAuthenticationAttributes(String activationId, String userId, Long applicationId, PowerAuthSignatureTypes signatureType, String version, PowerAuthHttpHeader httpHeader) {
        PowerAuthApiAuthenticationImpl apiAuthentication = new PowerAuthApiAuthenticationImpl();
        apiAuthentication.setActivationId(activationId);
        apiAuthentication.setUserId(userId);
        apiAuthentication.setApplicationId(applicationId);
        apiAuthentication.setSignatureFactors(signatureType);
        apiAuthentication.setAuthenticated(true);
        apiAuthentication.setVersion(version);
        apiAuthentication.setHttpHeader(httpHeader);
        return apiAuthentication;
    }

    public boolean supports(Class<?> authentication) {
        return authentication == PowerAuthSignatureAuthenticationImpl.class || authentication == PowerAuthTokenAuthenticationImpl.class;
    }

    public PowerAuthApiAuthentication validateRequestSignature(String httpMethod, byte[] httpBody, String requestUriIdentifier, String httpAuthorizationHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes, @Nullable Integer forcedSignatureVersion) throws PowerAuthAuthenticationException {
        boolean isApplicationAllowed;
        if (httpAuthorizationHeader == null || httpAuthorizationHeader.equals("undefined")) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_INVALID_EMPTY");
        }
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(httpAuthorizationHeader);
        try {
            PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PowerAuthAuthenticationException(e.getMessage());
        }
        if (this.applicationConfiguration != null && !(isApplicationAllowed = this.applicationConfiguration.isAllowedApplicationKey(header.getApplicationKey()))) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_INVALID_APPLICATION_ID");
        }
        PowerAuthSignatureTypes expectedSignatureType = PowerAuthSignatureTypes.getEnumFromString((String)header.getSignatureType());
        if (!allowedSignatureTypes.contains(expectedSignatureType)) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_TYPE_INVALID");
        }
        PowerAuthSignatureAuthenticationImpl powerAuthAuthentication = new PowerAuthSignatureAuthenticationImpl();
        powerAuthAuthentication.setActivationId(header.getActivationId());
        powerAuthAuthentication.setApplicationKey(header.getApplicationKey());
        powerAuthAuthentication.setNonce(BaseEncoding.base64().decode((CharSequence)header.getNonce()));
        powerAuthAuthentication.setSignatureType(header.getSignatureType());
        powerAuthAuthentication.setSignature(header.getSignature());
        powerAuthAuthentication.setHttpMethod(httpMethod);
        powerAuthAuthentication.setRequestUri(requestUriIdentifier);
        powerAuthAuthentication.setData(httpBody);
        powerAuthAuthentication.setVersion(header.getVersion());
        powerAuthAuthentication.setHttpHeader((PowerAuthHttpHeader)header);
        powerAuthAuthentication.setForcedSignatureVersion(forcedSignatureVersion);
        PowerAuthApiAuthentication auth = (PowerAuthApiAuthentication)this.authenticate((Authentication)powerAuthAuthentication);
        if (auth == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_INVALID_VALUE");
        }
        return auth;
    }

    public PowerAuthApiAuthentication validateToken(String tokenHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        if (tokenHeader == null || tokenHeader.equals("undefined")) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_TOKEN_INVALID_EMPTY");
        }
        PowerAuthTokenHttpHeader header = new PowerAuthTokenHttpHeader().fromValue(tokenHeader);
        try {
            PowerAuthTokenHttpHeaderValidator.validate((PowerAuthTokenHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new PowerAuthAuthenticationException(e.getMessage());
        }
        PowerAuthTokenAuthenticationImpl powerAuthTokenAuthentication = new PowerAuthTokenAuthenticationImpl();
        powerAuthTokenAuthentication.setTokenId(header.getTokenId());
        powerAuthTokenAuthentication.setTokenDigest(header.getTokenDigest());
        powerAuthTokenAuthentication.setNonce(header.getNonce());
        powerAuthTokenAuthentication.setTimestamp(header.getTimestamp());
        powerAuthTokenAuthentication.setVersion(header.getVersion());
        powerAuthTokenAuthentication.setHttpHeader((PowerAuthHttpHeader)header);
        PowerAuthApiAuthentication auth = (PowerAuthApiAuthentication)this.authenticate((Authentication)powerAuthTokenAuthentication);
        if (auth == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_TOKEN_INVALID_VALUE");
        }
        PowerAuthSignatureTypes expectedSignatureType = auth.getSignatureFactors();
        if (!allowedSignatureTypes.contains(expectedSignatureType)) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_TOKEN_SIGNATURE_TYPE_INVALID");
        }
        return auth;
    }
}

