/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.converter.v2;

import io.getlime.powerauth.soap.v2.SignatureType;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;

public class SignatureTypeConverter {
    public SignatureType convertFrom(String signatureTypeString) {
        if (signatureTypeString == null) {
            return SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
        }
        try {
            signatureTypeString = signatureTypeString.toUpperCase();
            return SignatureType.fromValue((String)signatureTypeString);
        }
        catch (IllegalArgumentException e) {
            return SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
        }
    }

    public SignatureType convertFrom(PowerAuthSignatureTypes powerAuthSignatureTypes) {
        switch (powerAuthSignatureTypes) {
            case POSSESSION: {
                return SignatureType.POSSESSION;
            }
            case KNOWLEDGE: {
                return SignatureType.KNOWLEDGE;
            }
            case BIOMETRY: {
                return SignatureType.BIOMETRY;
            }
            case POSSESSION_KNOWLEDGE: {
                return SignatureType.POSSESSION_KNOWLEDGE;
            }
            case POSSESSION_BIOMETRY: {
                return SignatureType.POSSESSION_BIOMETRY;
            }
        }
        return SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
    }
}

