/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.annotation;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.getlime.security.powerauth.rest.api.base.encryption.EciesEncryptionContext;
import io.getlime.security.powerauth.rest.api.base.encryption.PowerAuthEciesEncryption;
import io.getlime.security.powerauth.rest.api.spring.annotation.EncryptedRequestBody;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuthEncryption;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PowerAuthEncryptionArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthEncryptionArgumentResolver.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return parameter.hasMethodAnnotation(PowerAuthEncryption.class) && (parameter.hasParameterAnnotation(EncryptedRequestBody.class) || EciesEncryptionContext.class.isAssignableFrom(parameter.getParameterType()));
    }

    public Object resolveArgument(@NonNull MethodParameter parameter, ModelAndViewContainer mavContainer, @NonNull NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        EciesEncryptionContext eciesContext;
        boolean validScope;
        PowerAuthEncryption powerAuthEncryption;
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest();
        PowerAuthEciesEncryption eciesObject = (PowerAuthEciesEncryption)request.getAttribute("X-PowerAuth-Encryption-Object");
        if (parameter.hasParameterAnnotation(EncryptedRequestBody.class) && eciesObject != null && eciesObject.getDecryptedRequest() != null) {
            Class parameterType = parameter.getParameterType();
            if (parameterType.equals(byte[].class)) {
                return eciesObject.getDecryptedRequest();
            }
            try {
                return this.objectMapper.readValue(eciesObject.getDecryptedRequest(), parameterType);
            }
            catch (IOException ex) {
                logger.warn("Invalid request, error: {}", (Object)ex.getMessage());
                logger.debug("Error details", (Throwable)ex);
                return null;
            }
        }
        if (eciesObject != null && EciesEncryptionContext.class.isAssignableFrom(parameter.getParameterType()) && (powerAuthEncryption = (PowerAuthEncryption)parameter.getMethodAnnotation(PowerAuthEncryption.class)) != null && (validScope = this.validateEciesScope(eciesContext = eciesObject.getContext()))) {
            return eciesContext;
        }
        return null;
    }

    private boolean validateEciesScope(EciesEncryptionContext eciesContext) {
        switch (eciesContext.getEciesScope()) {
            case ACTIVATION_SCOPE: {
                if (eciesContext.getApplicationKey() == null || eciesContext.getApplicationKey().isEmpty()) {
                    logger.warn("ECIES activation scope is invalid because of missing application key");
                    return false;
                }
                if (eciesContext.getActivationId() != null && !eciesContext.getActivationId().isEmpty()) break;
                logger.warn("ECIES activation scope is invalid because of missing activation ID");
                return false;
            }
            case APPLICATION_SCOPE: {
                if (eciesContext.getApplicationKey() != null && !eciesContext.getApplicationKey().isEmpty()) break;
                logger.warn("ECIES application scope is invalid because of missing application key");
                return false;
            }
            default: {
                logger.warn("Unsupported ECIES scope: {}", (Object)eciesContext.getEciesScope());
                return false;
            }
        }
        return true;
    }
}

