/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.annotation;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.spring.annotation.EncryptedRequestBody;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuth;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuthEncryption;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuthToken;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthEncryptionProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

@Component
public class PowerAuthAnnotationInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthAnnotationInterceptor.class);
    private PowerAuthAuthenticationProvider authenticationProvider;
    private PowerAuthEncryptionProvider encryptionProvider;

    @Autowired
    public void setAuthenticationProvider(PowerAuthAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    @Autowired
    public void setEncryptionProvider(PowerAuthEncryptionProvider encryptionProvider) {
        this.encryptionProvider = encryptionProvider;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            PowerAuth powerAuthSignatureAnnotation = (PowerAuth)handlerMethod.getMethodAnnotation(PowerAuth.class);
            PowerAuthToken powerAuthTokenAnnotation = (PowerAuthToken)handlerMethod.getMethodAnnotation(PowerAuthToken.class);
            PowerAuthEncryption powerAuthEncryptionAnnotation = (PowerAuthEncryption)handlerMethod.getMethodAnnotation(PowerAuthEncryption.class);
            if (powerAuthSignatureAnnotation != null && powerAuthTokenAnnotation != null) {
                logger.warn("You cannot use both @PowerAuth and @PowerAuthToken on same handler method. We are removing both.");
                powerAuthSignatureAnnotation = null;
                powerAuthTokenAnnotation = null;
            }
            if (powerAuthEncryptionAnnotation != null) {
                Class<?> requestType = this.resolveGenericParameterTypeForEcies(handlerMethod);
                try {
                    this.encryptionProvider.decryptRequest(request, requestType, powerAuthEncryptionAnnotation.scope());
                }
                catch (PowerAuthEncryptionException ex) {
                    logger.warn("Decryption failed, error: {}", (Object)ex.getMessage());
                    logger.debug("Error details", (Throwable)ex);
                }
            }
            if (powerAuthSignatureAnnotation != null) {
                try {
                    String resourceId = this.expandResourceId(powerAuthSignatureAnnotation.resourceId(), request, handlerMethod);
                    String header = request.getHeader("X-PowerAuth-Authorization");
                    List<PowerAuthSignatureTypes> signatureTypes = Arrays.asList(powerAuthSignatureAnnotation.signatureType());
                    PowerAuthApiAuthentication authentication = this.authenticationProvider.validateRequestSignature(request, resourceId, header, signatureTypes);
                    request.setAttribute("X-PowerAuth-Authentication-Object", (Object)authentication);
                }
                catch (PowerAuthAuthenticationException ex) {
                    logger.warn("Invalid request signature, authentication object was removed");
                    request.setAttribute("X-PowerAuth-Authentication-Object", null);
                }
            }
            if (powerAuthTokenAnnotation != null) {
                try {
                    String header = request.getHeader("X-PowerAuth-Token");
                    List<PowerAuthSignatureTypes> signatureTypes = Arrays.asList(powerAuthTokenAnnotation.signatureType());
                    PowerAuthApiAuthentication authentication = this.authenticationProvider.validateToken(header, signatureTypes);
                    request.setAttribute("X-PowerAuth-Authentication-Object", (Object)authentication);
                }
                catch (PowerAuthAuthenticationException ex) {
                    logger.warn("Invalid token, authentication object was removed");
                    request.setAttribute("X-PowerAuth-Authentication-Object", null);
                }
            }
        }
        return true;
    }

    private Class<?> resolveGenericParameterTypeForEcies(HandlerMethod handlerMethod) {
        for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
            if (!parameter.hasParameterAnnotation(EncryptedRequestBody.class)) continue;
            return parameter.getParameterType();
        }
        return Object.class;
    }

    private String expandResourceId(String resourceId, HttpServletRequest request, HandlerMethod handlerMethod) {
        MethodParameter[] methodParameters;
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        for (MethodParameter mp : methodParameters = handlerMethod.getMethodParameters()) {
            String value;
            RequestParam requestParam = (RequestParam)mp.getParameterAnnotation(RequestParam.class);
            if (requestParam != null) {
                String name = requestParam.name();
                String value2 = request.getParameter(name);
                if (value2 == null) continue;
                parameters.put(name, value2);
                continue;
            }
            PathVariable pathVariable = (PathVariable)mp.getParameterAnnotation(PathVariable.class);
            if (pathVariable == null) continue;
            String name = pathVariable.name();
            Map pathVariableMap = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            if (pathVariableMap == null || parameters.containsKey(name) || (value = (String)pathVariableMap.get(name)) == null) continue;
            parameters.put(name, value);
        }
        StringSubstitutor sub = new StringSubstitutor(parameters);
        return sub.replace(resourceId);
    }
}

