/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesDecryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.rest.api.base.encryption.PowerAuthEciesEncryption;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuthEncryption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class EncryptionResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger logger = LoggerFactory.getLogger(EncryptionResponseBodyAdvice.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;

    @Autowired
    public void setRequestMappingHandlerAdapter(RequestMappingHandlerAdapter requestMappingHandlerAdapter) {
        this.requestMappingHandlerAdapter = requestMappingHandlerAdapter;
    }

    public boolean supports(@NonNull MethodParameter methodParameter, @NonNull Class<? extends HttpMessageConverter<?>> converterClass) {
        return methodParameter.hasMethodAnnotation(PowerAuthEncryption.class) && (converterClass.isAssignableFrom(MappingJackson2HttpMessageConverter.class) || converterClass.isAssignableFrom(StringHttpMessageConverter.class) || converterClass.isAssignableFrom(ByteArrayHttpMessageConverter.class));
    }

    public Object beforeBodyWrite(Object response, @NonNull MethodParameter methodParameter, @NonNull MediaType mediaType, @NonNull Class<? extends HttpMessageConverter<?>> converterClass, @NonNull ServerHttpRequest serverHttpRequest, @NonNull ServerHttpResponse serverHttpResponse) {
        if (response == null) {
            return null;
        }
        HttpServletRequest httpServletRequest = ((ServletServerHttpRequest)serverHttpRequest).getServletRequest();
        PowerAuthEciesEncryption eciesEncryption = (PowerAuthEciesEncryption)httpServletRequest.getAttribute("X-PowerAuth-Encryption-Object");
        if (eciesEncryption == null) {
            return null;
        }
        try {
            byte[] responseBytes = this.serializeResponseObject(response);
            EciesDecryptor eciesDecryptor = eciesEncryption.getEciesDecryptor();
            EciesCryptogram cryptogram = eciesDecryptor.encryptResponse(responseBytes);
            String encryptedDataBase64 = BaseEncoding.base64().encode(cryptogram.getEncryptedData());
            String macBase64 = BaseEncoding.base64().encode(cryptogram.getMac());
            EciesEncryptedResponse encryptedResponse = new EciesEncryptedResponse(encryptedDataBase64, macBase64);
            if (converterClass.isAssignableFrom(MappingJackson2HttpMessageConverter.class)) {
                return encryptedResponse;
            }
            if (converterClass.isAssignableFrom(StringHttpMessageConverter.class)) {
                return new String(this.convertEncryptedResponse(encryptedResponse, mediaType), StandardCharsets.UTF_8);
            }
            return this.convertEncryptedResponse(encryptedResponse, mediaType);
        }
        catch (Exception ex) {
            logger.warn("Encryption failed, error: {}", (Object)ex.getMessage());
            logger.debug("Error details", (Throwable)ex);
            return null;
        }
    }

    private byte[] serializeResponseObject(Object response) throws IOException {
        if (response.getClass().equals(byte[].class)) {
            return (byte[])response;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.objectMapper.writeValue((OutputStream)baos, response);
        return baos.toByteArray();
    }

    private byte[] convertEncryptedResponse(EciesEncryptedResponse encryptedResponse, MediaType mediaType) throws IOException {
        List httpMessageConverters = this.requestMappingHandlerAdapter.getMessageConverters();
        for (HttpMessageConverter converter : httpMessageConverters) {
            if (!converter.canWrite(encryptedResponse.getClass(), mediaType)) continue;
            BasicHttpOutputMessage httpOutputMessage = new BasicHttpOutputMessage();
            converter.write((Object)encryptedResponse, mediaType, (HttpOutputMessage)httpOutputMessage);
            return httpOutputMessage.getBodyBytes();
        }
        throw new IOException("Response message conversion failed, no applicable HTTP message converter found");
    }

    private static class BasicHttpOutputMessage
    implements HttpOutputMessage {
        private final ByteArrayOutputStream os = new ByteArrayOutputStream();
        private final HttpHeaders httpHeaders = new HttpHeaders();

        private BasicHttpOutputMessage() {
        }

        @NonNull
        public OutputStream getBody() {
            return this.os;
        }

        public byte[] getBodyBytes() {
            return this.os.toByteArray();
        }

        @NonNull
        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }
    }
}

