/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.provider;

import com.google.common.io.BaseEncoding;
import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.model.error.PowerAuthClientException;
import com.wultra.security.powerauth.client.v3.SignatureType;
import com.wultra.security.powerauth.client.v3.ValidateTokenRequest;
import com.wultra.security.powerauth.client.v3.ValidateTokenResponse;
import com.wultra.security.powerauth.client.v3.VerifySignatureRequest;
import com.wultra.security.powerauth.client.v3.VerifySignatureResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthTokenHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.http.validator.PowerAuthTokenHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthHeaderMissingException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthSignatureInvalidException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthSignatureTypeInvalidException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthTokenInvalidException;
import io.getlime.security.powerauth.rest.api.base.provider.PowerAuthAuthenticationProviderBase;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthApiAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthSignatureAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthTokenAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.spring.converter.v3.SignatureTypeConverter;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class PowerAuthAuthenticationProvider
extends PowerAuthAuthenticationProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthAuthenticationProvider.class);
    private PowerAuthClient powerAuthClient;

    @Autowired
    public void setPowerAuthClient(PowerAuthClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication instanceof PowerAuthSignatureAuthenticationImpl) {
            return this.validateSignatureAuthentication((PowerAuthSignatureAuthenticationImpl)authentication);
        }
        if (authentication instanceof PowerAuthTokenAuthenticationImpl) {
            return this.validateTokenAuthentication((PowerAuthTokenAuthenticationImpl)authentication);
        }
        return null;
    }

    private PowerAuthApiAuthenticationImpl validateSignatureAuthentication(PowerAuthSignatureAuthenticationImpl authentication) {
        if (authentication.getSignatureType() != null) {
            VerifySignatureResponse response;
            SignatureTypeConverter converter = new SignatureTypeConverter();
            SignatureType signatureType = converter.convertFrom(authentication.getSignatureType());
            if (signatureType == null) {
                return null;
            }
            VerifySignatureRequest request = new VerifySignatureRequest();
            request.setActivationId(authentication.getActivationId());
            request.setApplicationKey(authentication.getApplicationKey());
            request.setSignature(authentication.getSignature());
            request.setSignatureType(signatureType);
            request.setSignatureVersion(authentication.getVersion());
            request.setData(PowerAuthHttpBody.getSignatureBaseString((String)authentication.getHttpMethod(), (String)authentication.getRequestUri(), (byte[])authentication.getNonce(), (byte[])authentication.getData()));
            if (authentication.getForcedSignatureVersion() != null) {
                request.setForcedSignatureVersion(Long.valueOf(authentication.getForcedSignatureVersion().longValue()));
            }
            try {
                response = this.powerAuthClient.verifySignature(request);
            }
            catch (PowerAuthClientException ex) {
                logger.warn("Signature validation failed, error: {}", (Object)ex.getMessage());
                logger.debug("Error details", (Throwable)ex);
                return null;
            }
            if (response.isSignatureValid()) {
                return this.copyAuthenticationAttributes(response.getActivationId(), response.getUserId(), response.getApplicationId(), response.getApplicationRoles(), response.getActivationFlags(), PowerAuthSignatureTypes.getEnumFromString((String)response.getSignatureType().value()), authentication.getVersion(), authentication.getHttpHeader());
            }
            return null;
        }
        return null;
    }

    private PowerAuthApiAuthenticationImpl validateTokenAuthentication(PowerAuthTokenAuthenticationImpl authentication) {
        try {
            ValidateTokenRequest soapRequest = new ValidateTokenRequest();
            soapRequest.setTokenId(authentication.getTokenId());
            soapRequest.setTokenDigest(authentication.getTokenDigest());
            soapRequest.setNonce(authentication.getNonce());
            soapRequest.setTimestamp(Long.parseLong(authentication.getTimestamp()));
            ValidateTokenResponse soapResponse = this.powerAuthClient.validateToken(soapRequest);
            if (soapResponse.isTokenValid()) {
                return this.copyAuthenticationAttributes(soapResponse.getActivationId(), soapResponse.getUserId(), soapResponse.getApplicationId(), soapResponse.getApplicationRoles(), soapResponse.getActivationFlags(), PowerAuthSignatureTypes.getEnumFromString((String)soapResponse.getSignatureType().value()), authentication.getVersion(), authentication.getHttpHeader());
            }
            return null;
        }
        catch (NumberFormatException ex) {
            logger.warn("Invalid timestamp format, error: {}", (Object)ex.getMessage());
            logger.debug("Error details", (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            logger.warn("Token validation failed, error: {}", (Object)ex.getMessage());
            logger.debug("Error details", (Throwable)ex);
            return null;
        }
    }

    private PowerAuthApiAuthenticationImpl copyAuthenticationAttributes(String activationId, String userId, Long applicationId, List<String> applicationRoles, List<String> activationFlags, PowerAuthSignatureTypes signatureType, String version, PowerAuthHttpHeader httpHeader) {
        PowerAuthApiAuthenticationImpl apiAuthentication = new PowerAuthApiAuthenticationImpl();
        apiAuthentication.setActivationId(activationId);
        apiAuthentication.setUserId(userId);
        apiAuthentication.setApplicationId(applicationId);
        apiAuthentication.setApplicationRoles(applicationRoles);
        apiAuthentication.setActivationFlags(activationFlags);
        apiAuthentication.setSignatureFactors(signatureType);
        apiAuthentication.setAuthenticated(true);
        apiAuthentication.setVersion(version);
        apiAuthentication.setHttpHeader(httpHeader);
        return apiAuthentication;
    }

    public PowerAuthApiAuthentication validateRequestSignature(String httpMethod, byte[] httpBody, String requestUriIdentifier, String httpAuthorizationHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes, @Nullable Integer forcedSignatureVersion) throws PowerAuthAuthenticationException {
        if (httpAuthorizationHeader == null || httpAuthorizationHeader.equals("undefined")) {
            logger.warn("Signature HTTP header is missing");
            throw new PowerAuthHeaderMissingException();
        }
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(httpAuthorizationHeader);
        try {
            PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            logger.warn("Signature HTTP header validation failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthSignatureInvalidException();
        }
        PowerAuthSignatureTypes expectedSignatureType = PowerAuthSignatureTypes.getEnumFromString((String)header.getSignatureType());
        if (expectedSignatureType == null || !allowedSignatureTypes.contains(expectedSignatureType)) {
            logger.warn("Invalid signature type: {}", (Object)expectedSignatureType);
            throw new PowerAuthSignatureTypeInvalidException();
        }
        PowerAuthSignatureAuthenticationImpl powerAuthAuthentication = new PowerAuthSignatureAuthenticationImpl();
        powerAuthAuthentication.setActivationId(header.getActivationId());
        powerAuthAuthentication.setApplicationKey(header.getApplicationKey());
        powerAuthAuthentication.setNonce(BaseEncoding.base64().decode((CharSequence)header.getNonce()));
        powerAuthAuthentication.setSignatureType(header.getSignatureType());
        powerAuthAuthentication.setSignature(header.getSignature());
        powerAuthAuthentication.setHttpMethod(httpMethod);
        powerAuthAuthentication.setRequestUri(requestUriIdentifier);
        powerAuthAuthentication.setData(httpBody);
        powerAuthAuthentication.setVersion(header.getVersion());
        powerAuthAuthentication.setHttpHeader((PowerAuthHttpHeader)header);
        powerAuthAuthentication.setForcedSignatureVersion(forcedSignatureVersion);
        PowerAuthApiAuthentication auth = (PowerAuthApiAuthentication)this.authenticate((Authentication)powerAuthAuthentication);
        if (auth == null) {
            logger.debug("Signature validation failed");
            throw new PowerAuthSignatureInvalidException();
        }
        return auth;
    }

    public PowerAuthApiAuthentication validateToken(String tokenHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        if (tokenHeader == null || tokenHeader.equals("undefined")) {
            logger.warn("Token HTTP header is missing");
            throw new PowerAuthHeaderMissingException();
        }
        PowerAuthTokenHttpHeader header = new PowerAuthTokenHttpHeader().fromValue(tokenHeader);
        try {
            PowerAuthTokenHttpHeaderValidator.validate((PowerAuthTokenHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            logger.warn("Token validation failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthTokenInvalidException();
        }
        PowerAuthTokenAuthenticationImpl powerAuthTokenAuthentication = new PowerAuthTokenAuthenticationImpl();
        powerAuthTokenAuthentication.setTokenId(header.getTokenId());
        powerAuthTokenAuthentication.setTokenDigest(header.getTokenDigest());
        powerAuthTokenAuthentication.setNonce(header.getNonce());
        powerAuthTokenAuthentication.setTimestamp(header.getTimestamp());
        powerAuthTokenAuthentication.setVersion(header.getVersion());
        powerAuthTokenAuthentication.setHttpHeader((PowerAuthHttpHeader)header);
        PowerAuthApiAuthentication auth = (PowerAuthApiAuthentication)this.authenticate((Authentication)powerAuthTokenAuthentication);
        if (auth == null) {
            logger.debug("Invalid token value");
            throw new PowerAuthTokenInvalidException();
        }
        PowerAuthSignatureTypes expectedSignatureType = auth.getSignatureFactors();
        if (expectedSignatureType == null || !allowedSignatureTypes.contains(expectedSignatureType)) {
            logger.warn("Invalid signature type in token validation: {}", (Object)expectedSignatureType);
            throw new PowerAuthSignatureTypeInvalidException();
        }
        return auth;
    }
}

