/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.encryption;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.lib.encryptor.NonPersonalizedEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.NonPersonalizedEncryptedMessage;
import io.getlime.security.powerauth.crypto.lib.model.exception.CryptoProviderException;
import io.getlime.security.powerauth.crypto.lib.model.exception.GenericCryptoException;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import java.io.IOException;
import java.security.InvalidKeyException;

public class PowerAuthNonPersonalizedEncryptor {
    private final NonPersonalizedEncryptor encryptor;
    private final ObjectMapper mapper = new ObjectMapper();

    public PowerAuthNonPersonalizedEncryptor(String applicationKeyBase64, String sessionKeyBytesBase64, String sessionIndexBase64, String ephemeralPublicKeyBase64) {
        byte[] applicationKey = BaseEncoding.base64().decode((CharSequence)applicationKeyBase64);
        byte[] sessionIndex = BaseEncoding.base64().decode((CharSequence)sessionIndexBase64);
        byte[] sessionKeyBytes = BaseEncoding.base64().decode((CharSequence)sessionKeyBytesBase64);
        byte[] ephemeralKeyBytes = BaseEncoding.base64().decode((CharSequence)ephemeralPublicKeyBase64);
        this.encryptor = new NonPersonalizedEncryptor(applicationKey, sessionKeyBytes, sessionIndex, ephemeralKeyBytes);
    }

    public ObjectResponse<NonPersonalizedEncryptedPayloadModel> encrypt(Object object) throws JsonProcessingException, GenericCryptoException, CryptoProviderException, InvalidKeyException {
        if (object == null) {
            return null;
        }
        byte[] originalData = this.mapper.writeValueAsBytes(object);
        return this.encrypt(originalData);
    }

    public ObjectResponse<NonPersonalizedEncryptedPayloadModel> encrypt(byte[] originalData) throws GenericCryptoException, CryptoProviderException, InvalidKeyException {
        if (originalData == null) {
            return null;
        }
        NonPersonalizedEncryptedMessage message = this.encryptor.encrypt(originalData);
        if (message == null) {
            return null;
        }
        NonPersonalizedEncryptedPayloadModel responseObject = new NonPersonalizedEncryptedPayloadModel();
        responseObject.setApplicationKey(BaseEncoding.base64().encode(message.getApplicationKey()));
        responseObject.setEphemeralPublicKey(BaseEncoding.base64().encode(message.getEphemeralPublicKey()));
        responseObject.setSessionIndex(BaseEncoding.base64().encode(message.getSessionIndex()));
        responseObject.setAdHocIndex(BaseEncoding.base64().encode(message.getAdHocIndex()));
        responseObject.setMacIndex(BaseEncoding.base64().encode(message.getMacIndex()));
        responseObject.setNonce(BaseEncoding.base64().encode(message.getNonce()));
        responseObject.setMac(BaseEncoding.base64().encode(message.getMac()));
        responseObject.setEncryptedData(BaseEncoding.base64().encode(message.getEncryptedData()));
        return new ObjectResponse((Object)responseObject);
    }

    public byte[] decrypt(ObjectRequest<NonPersonalizedEncryptedPayloadModel> request) throws GenericCryptoException, CryptoProviderException, InvalidKeyException {
        if (request == null) {
            return null;
        }
        NonPersonalizedEncryptedPayloadModel requestObject = (NonPersonalizedEncryptedPayloadModel)request.getRequestObject();
        if (requestObject == null) {
            return null;
        }
        NonPersonalizedEncryptedMessage message = new NonPersonalizedEncryptedMessage();
        message.setApplicationKey(BaseEncoding.base64().decode((CharSequence)requestObject.getApplicationKey()));
        message.setEphemeralPublicKey(BaseEncoding.base64().decode((CharSequence)requestObject.getEphemeralPublicKey()));
        message.setSessionIndex(BaseEncoding.base64().decode((CharSequence)requestObject.getSessionIndex()));
        message.setAdHocIndex(BaseEncoding.base64().decode((CharSequence)requestObject.getAdHocIndex()));
        message.setMacIndex(BaseEncoding.base64().decode((CharSequence)requestObject.getMacIndex()));
        message.setNonce(BaseEncoding.base64().decode((CharSequence)requestObject.getNonce()));
        message.setMac(BaseEncoding.base64().decode((CharSequence)requestObject.getMac()));
        message.setEncryptedData(BaseEncoding.base64().decode((CharSequence)requestObject.getEncryptedData()));
        return this.encryptor.decrypt(message);
    }

    public <T> T decrypt(ObjectRequest<NonPersonalizedEncryptedPayloadModel> request, Class<T> resultClass) throws IOException, GenericCryptoException, CryptoProviderException, InvalidKeyException {
        byte[] result = this.decrypt(request);
        if (result == null) {
            return null;
        }
        return (T)this.mapper.readValue(result, resultClass);
    }
}

