/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.annotation.support;

import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthActivation;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthApiAuthentication;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PowerAuthWebArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return PowerAuthApiAuthentication.class.isAssignableFrom(parameter.getParameterType()) || PowerAuthActivation.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(@NonNull MethodParameter parameter, ModelAndViewContainer mavContainer, @NonNull NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        PowerAuthApiAuthentication apiAuthentication;
        HttpServletRequest request;
        if (parameter.getParameterType().isAssignableFrom(PowerAuthApiAuthentication.class)) {
            request = (HttpServletRequest)webRequest.getNativeRequest();
            apiAuthentication = (PowerAuthApiAuthentication)request.getAttribute("X-PowerAuth-Authentication-Object");
            if (apiAuthentication == null) {
                return null;
            }
            if (apiAuthentication.getAuthenticationContext().isValid()) {
                return apiAuthentication;
            }
        }
        if (parameter.getParameterType().isAssignableFrom(PowerAuthActivation.class)) {
            request = (HttpServletRequest)webRequest.getNativeRequest();
            apiAuthentication = (PowerAuthApiAuthentication)request.getAttribute("X-PowerAuth-Authentication-Object");
            if (apiAuthentication == null) {
                return null;
            }
            return apiAuthentication.getActivationContext();
        }
        return null;
    }
}

