/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.converter.v3;

import com.wultra.security.powerauth.client.v3.SignatureType;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureTypeConverter {
    private static final Logger logger = LoggerFactory.getLogger(SignatureTypeConverter.class);

    public SignatureType convertFrom(String signatureTypeString) {
        if (signatureTypeString == null) {
            return null;
        }
        try {
            signatureTypeString = signatureTypeString.toUpperCase();
            return SignatureType.fromValue((String)signatureTypeString);
        }
        catch (IllegalArgumentException ex) {
            logger.warn("Invalid signature type, error: {}", (Object)ex.getMessage());
            logger.debug("Error details", (Throwable)ex);
            return null;
        }
    }

    public SignatureType convertFrom(PowerAuthSignatureTypes powerAuthSignatureTypes) {
        switch (powerAuthSignatureTypes) {
            case POSSESSION: {
                return SignatureType.POSSESSION;
            }
            case KNOWLEDGE: {
                return SignatureType.KNOWLEDGE;
            }
            case BIOMETRY: {
                return SignatureType.BIOMETRY;
            }
            case POSSESSION_KNOWLEDGE: {
                return SignatureType.POSSESSION_KNOWLEDGE;
            }
            case POSSESSION_BIOMETRY: {
                return SignatureType.POSSESSION_BIOMETRY;
            }
        }
        return null;
    }
}

