/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.provider;

import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.v3.GetEciesDecryptorRequest;
import com.wultra.security.powerauth.client.v3.GetEciesDecryptorResponse;
import io.getlime.security.powerauth.rest.api.spring.encryption.PowerAuthEciesDecryptorParameters;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthEncryptionProviderBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PowerAuthEncryptionProvider
extends PowerAuthEncryptionProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthEncryptionProvider.class);
    private PowerAuthClient powerAuthClient;

    @Autowired
    public void setPowerAuthClient(PowerAuthClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @Override
    @Nonnull
    public PowerAuthEciesDecryptorParameters getEciesDecryptorParameters(@Nullable String activationId, @Nonnull String applicationKey, @Nonnull String ephemeralPublicKey) throws PowerAuthEncryptionException {
        try {
            GetEciesDecryptorRequest eciesDecryptorRequest = new GetEciesDecryptorRequest();
            eciesDecryptorRequest.setActivationId(activationId);
            eciesDecryptorRequest.setApplicationKey(applicationKey);
            eciesDecryptorRequest.setEphemeralPublicKey(ephemeralPublicKey);
            GetEciesDecryptorResponse eciesDecryptorResponse = this.powerAuthClient.getEciesDecryptor(eciesDecryptorRequest);
            return new PowerAuthEciesDecryptorParameters(eciesDecryptorResponse.getSecretKey(), eciesDecryptorResponse.getSharedInfo2());
        }
        catch (Exception ex) {
            logger.warn("Get ECIES decryptor call failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthEncryptionException();
        }
    }
}

