/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.authentication.impl;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthHttpHeader;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthActivation;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.spring.authentication.impl.PowerAuthActivationImpl;
import io.getlime.security.powerauth.rest.api.spring.model.AuthenticationContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class PowerAuthApiAuthenticationImpl
extends AbstractAuthenticationToken
implements PowerAuthApiAuthentication,
Serializable {
    private static final long serialVersionUID = -3790516505615465445L;
    private String activationId;
    private String userId;
    private String applicationId;
    private List<String> applicationRoles = new ArrayList<String>();
    private List<String> activationFlags = new ArrayList<String>();
    private PowerAuthSignatureTypes factors;
    private AuthenticationContext authenticationContext;
    private String version;
    private PowerAuthHttpHeader httpHeader;
    private PowerAuthActivation activationContext;

    public PowerAuthApiAuthenticationImpl() {
        super(null);
    }

    public PowerAuthApiAuthenticationImpl(String activationId, String userId, String applicationId, List<String> applicationRoles, List<String> activationFlags, AuthenticationContext authenticationContext) {
        super(null);
        this.activationId = activationId;
        this.userId = userId;
        this.applicationId = applicationId;
        if (applicationRoles != null) {
            this.applicationRoles = new ArrayList<String>(applicationRoles);
        }
        if (activationFlags != null) {
            this.activationFlags = new ArrayList<String>(activationFlags);
        }
        this.authenticationContext = authenticationContext;
        if (authenticationContext != null) {
            this.factors = authenticationContext.getSignatureType();
        }
        this.activationContext = new PowerAuthActivationImpl();
        this.activationContext.setActivationId(activationId);
        this.activationContext.setUserId(userId);
        this.activationContext.setActivationFlags(activationFlags);
        this.activationContext.setAuthenticationContext(authenticationContext);
        this.activationContext.setVersion(this.version);
    }

    public String getName() {
        return this.userId;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>(1);
        authorities.add(new SimpleGrantedAuthority("USER"));
        return Collections.unmodifiableList(authorities);
    }

    public Object getCredentials() {
        return null;
    }

    public Object getPrincipal() {
        return this.activationId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getActivationId() {
        return this.activationId;
    }

    @Override
    public void setActivationId(String activationId) {
        this.activationId = activationId;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public void setApplicationId(String id) {
        this.applicationId = id;
    }

    @Override
    public List<String> getApplicationRoles() {
        return this.applicationRoles;
    }

    @Override
    public void setApplicationRoles(List<String> applicationRoles) {
        this.applicationRoles = applicationRoles == null ? Collections.emptyList() : new ArrayList<String>(applicationRoles);
    }

    @Override
    public List<String> getActivationFlags() {
        return this.activationFlags;
    }

    @Override
    public void setActivationFlags(List<String> activationFlags) {
        this.activationFlags = activationFlags == null ? Collections.emptyList() : new ArrayList<String>(activationFlags);
    }

    @Override
    public PowerAuthSignatureTypes getSignatureFactors() {
        return this.factors;
    }

    @Override
    public void setSignatureFactors(PowerAuthSignatureTypes factors) {
        this.factors = factors;
    }

    @Override
    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    @Override
    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        if (authenticationContext != null) {
            this.setSignatureFactors(authenticationContext.getSignatureType());
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public PowerAuthHttpHeader getHttpHeader() {
        return this.httpHeader;
    }

    @Override
    public void setHttpHeader(PowerAuthHttpHeader httpHeader) {
        this.httpHeader = httpHeader;
    }

    @Override
    public PowerAuthActivation getActivationContext() {
        return this.activationContext;
    }

    @Override
    public void setActivationContext(PowerAuthActivation activationContext) {
        this.activationContext = activationContext;
        if (activationContext != null) {
            this.setActivationId(activationContext.getActivationId());
            this.setActivationFlags(activationContext.getActivationFlags());
        }
    }
}

