/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.converter.v3;

import com.wultra.security.powerauth.client.v3.GetActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.spring.converter.v3.ActivationStatusConverter;
import io.getlime.security.powerauth.rest.api.spring.model.ActivationContext;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.springframework.stereotype.Component;

@Component
public class ActivationContextConverter {
    private final ActivationStatusConverter activationStatusConverter;

    public ActivationContextConverter(ActivationStatusConverter activationStatusConverter) {
        this.activationStatusConverter = activationStatusConverter;
    }

    public ActivationContext fromActivationDetailResponse(GetActivationStatusResponse source) {
        XMLGregorianCalendar timestampLastChange;
        XMLGregorianCalendar timestampLastUsed;
        XMLGregorianCalendar timestampCreated;
        ActivationContext destination = new ActivationContext();
        destination.setActivationId(source.getActivationId());
        destination.setActivationName(source.getActivationName());
        destination.setActivationStatus(this.activationStatusConverter.convertFrom(source.getActivationStatus()));
        destination.setBlockedReason(source.getBlockedReason());
        destination.setApplicationId(source.getApplicationId());
        destination.setUserId(source.getUserId());
        destination.setVersion(source.getVersion());
        destination.setPlatform(source.getPlatform());
        destination.setDeviceInfo(source.getDeviceInfo());
        destination.setExtras(source.getExtras());
        List activationFlags = source.getActivationFlags();
        if (activationFlags != null) {
            destination.getActivationFlags().addAll(activationFlags);
        }
        if ((timestampCreated = source.getTimestampCreated()) != null) {
            destination.setTimestampCreated(timestampCreated.toGregorianCalendar().toInstant());
        }
        if ((timestampLastUsed = source.getTimestampLastUsed()) != null) {
            destination.setTimestampLastUsed(timestampLastUsed.toGregorianCalendar().toInstant());
        }
        if ((timestampLastChange = source.getTimestampLastChange()) != null) {
            destination.setTimestampLastChange(timestampLastChange.toGregorianCalendar().toInstant());
        }
        return destination;
    }
}

