/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.encryption;

import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.model.error.PowerAuthClientException;
import com.wultra.security.powerauth.client.v2.GetNonPersonalizedEncryptionKeyRequest;
import com.wultra.security.powerauth.client.v2.GetNonPersonalizedEncryptionKeyResponse;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import io.getlime.security.powerauth.rest.api.spring.encryption.PowerAuthNonPersonalizedEncryptor;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.spring.service.HttpCustomizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EncryptorFactory {
    private static final Logger logger = LoggerFactory.getLogger(EncryptorFactory.class);
    private final PowerAuthClient powerAuthClient;
    private final HttpCustomizationService httpCustomizationService;

    @Autowired
    public EncryptorFactory(PowerAuthClient powerAuthClient, HttpCustomizationService httpCustomizationService) {
        this.powerAuthClient = powerAuthClient;
        this.httpCustomizationService = httpCustomizationService;
    }

    public PowerAuthNonPersonalizedEncryptor buildNonPersonalizedEncryptor(ObjectRequest<NonPersonalizedEncryptedPayloadModel> object) throws PowerAuthEncryptionException {
        return this.buildNonPersonalizedEncryptor(((NonPersonalizedEncryptedPayloadModel)object.getRequestObject()).getApplicationKey(), ((NonPersonalizedEncryptedPayloadModel)object.getRequestObject()).getSessionIndex(), ((NonPersonalizedEncryptedPayloadModel)object.getRequestObject()).getEphemeralPublicKey());
    }

    public PowerAuthNonPersonalizedEncryptor buildNonPersonalizedEncryptor(String applicationKeyBase64, String sessionIndexBase64, String ephemeralPublicKeyBase64) throws PowerAuthEncryptionException {
        try {
            GetNonPersonalizedEncryptionKeyRequest encryptRequest = new GetNonPersonalizedEncryptionKeyRequest();
            encryptRequest.setApplicationKey(applicationKeyBase64);
            encryptRequest.setEphemeralPublicKey(ephemeralPublicKeyBase64);
            encryptRequest.setSessionIndex(sessionIndexBase64);
            GetNonPersonalizedEncryptionKeyResponse encryptionKeyResponse = this.powerAuthClient.v2().generateNonPersonalizedE2EEncryptionKey(encryptRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
            return new PowerAuthNonPersonalizedEncryptor(encryptionKeyResponse.getApplicationKey(), encryptionKeyResponse.getEncryptionKey(), encryptionKeyResponse.getEncryptionKeyIndex(), encryptionKeyResponse.getEphemeralPublicKey());
        }
        catch (PowerAuthClientException ex) {
            logger.warn("Encryption failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthEncryptionException();
        }
    }
}

