/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.provider;

import com.google.common.io.BaseEncoding;
import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.model.error.PowerAuthClientException;
import com.wultra.security.powerauth.client.v3.SignatureType;
import com.wultra.security.powerauth.client.v3.ValidateTokenRequest;
import com.wultra.security.powerauth.client.v3.ValidateTokenResponse;
import com.wultra.security.powerauth.client.v3.VerifySignatureRequest;
import com.wultra.security.powerauth.client.v3.VerifySignatureResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthTokenHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.http.validator.PowerAuthTokenHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthActivation;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.spring.authentication.impl.PowerAuthActivationImpl;
import io.getlime.security.powerauth.rest.api.spring.authentication.impl.PowerAuthApiAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.spring.authentication.impl.PowerAuthSignatureAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.spring.authentication.impl.PowerAuthTokenAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.spring.converter.v3.ActivationStatusConverter;
import io.getlime.security.powerauth.rest.api.spring.converter.v3.SignatureTypeConverter;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthHeaderMissingException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthSignatureInvalidException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthSignatureTypeInvalidException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthTokenInvalidException;
import io.getlime.security.powerauth.rest.api.spring.model.ActivationStatus;
import io.getlime.security.powerauth.rest.api.spring.model.AuthenticationContext;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthAuthenticationProviderBase;
import io.getlime.security.powerauth.rest.api.spring.service.HttpCustomizationService;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class PowerAuthAuthenticationProvider
extends PowerAuthAuthenticationProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthAuthenticationProvider.class);
    private final PowerAuthClient powerAuthClient;
    private final ActivationStatusConverter activationStatusConverter;
    private final HttpCustomizationService httpCustomizationService;

    @Autowired
    public PowerAuthAuthenticationProvider(PowerAuthClient powerAuthClient, ActivationStatusConverter activationStatusConverter, HttpCustomizationService httpCustomizationService) {
        this.powerAuthClient = powerAuthClient;
        this.activationStatusConverter = activationStatusConverter;
        this.httpCustomizationService = httpCustomizationService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication instanceof PowerAuthSignatureAuthenticationImpl) {
            return this.validateSignatureAuthentication((PowerAuthSignatureAuthenticationImpl)authentication);
        }
        if (authentication instanceof PowerAuthTokenAuthenticationImpl) {
            return this.validateTokenAuthentication((PowerAuthTokenAuthenticationImpl)authentication);
        }
        return null;
    }

    private PowerAuthApiAuthenticationImpl validateSignatureAuthentication(PowerAuthSignatureAuthenticationImpl authentication) {
        if (authentication.getSignatureType() != null) {
            VerifySignatureResponse response;
            SignatureTypeConverter converter = new SignatureTypeConverter();
            SignatureType signatureType = converter.convertFrom(authentication.getSignatureType());
            if (signatureType == null) {
                return null;
            }
            VerifySignatureRequest verifyRequest = new VerifySignatureRequest();
            verifyRequest.setActivationId(authentication.getActivationId());
            verifyRequest.setApplicationKey(authentication.getApplicationKey());
            verifyRequest.setSignature(authentication.getSignature());
            verifyRequest.setSignatureType(signatureType);
            verifyRequest.setSignatureVersion(authentication.getVersion());
            verifyRequest.setData(PowerAuthHttpBody.getSignatureBaseString((String)authentication.getHttpMethod(), (String)authentication.getRequestUri(), (byte[])authentication.getNonce(), (byte[])authentication.getData()));
            if (authentication.getForcedSignatureVersion() != null) {
                verifyRequest.setForcedSignatureVersion(Long.valueOf(authentication.getForcedSignatureVersion().longValue()));
            }
            try {
                response = this.powerAuthClient.verifySignature(verifyRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
            }
            catch (PowerAuthClientException ex) {
                logger.warn("Signature validation failed, error: {}", (Object)ex.getMessage());
                logger.debug("Error details", (Throwable)ex);
                return null;
            }
            AuthenticationContext authenticationContext = new AuthenticationContext();
            authenticationContext.setValid(response.isSignatureValid());
            authenticationContext.setRemainingAttempts(response.getRemainingAttempts() != null ? Integer.valueOf(response.getRemainingAttempts().intValue()) : null);
            authenticationContext.setSignatureType(response.getSignatureType() != null ? PowerAuthSignatureTypes.getEnumFromString((String)response.getSignatureType().value()) : null);
            PowerAuthActivationImpl activationContext = this.copyActivationAttributes(response.getActivationId(), response.getUserId(), this.activationStatusConverter.convertFrom(response.getActivationStatus()), response.getBlockedReason(), response.getActivationFlags(), authenticationContext, authentication.getVersion());
            return this.copyAuthenticationAttributes(response.getActivationId(), response.getUserId(), response.getApplicationId(), response.getApplicationRoles(), response.getActivationFlags(), authenticationContext, authentication.getVersion(), authentication.getHttpHeader(), activationContext);
        }
        return null;
    }

    private PowerAuthApiAuthenticationImpl validateTokenAuthentication(PowerAuthTokenAuthenticationImpl authentication) {
        try {
            ValidateTokenRequest validateRequest = new ValidateTokenRequest();
            validateRequest.setTokenId(authentication.getTokenId());
            validateRequest.setTokenDigest(authentication.getTokenDigest());
            validateRequest.setNonce(authentication.getNonce());
            validateRequest.setTimestamp(Long.parseLong(authentication.getTimestamp()));
            ValidateTokenResponse response = this.powerAuthClient.validateToken(validateRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
            ActivationStatus activationStatus = response.isTokenValid() ? ActivationStatus.ACTIVE : null;
            AuthenticationContext authenticationContext = new AuthenticationContext();
            authenticationContext.setValid(response.isTokenValid());
            authenticationContext.setRemainingAttempts(null);
            authenticationContext.setSignatureType(response.getSignatureType() != null ? PowerAuthSignatureTypes.getEnumFromString((String)response.getSignatureType().value()) : null);
            PowerAuthActivationImpl activationContext = this.copyActivationAttributes(response.getActivationId(), response.getUserId(), activationStatus, null, response.getActivationFlags(), authenticationContext, authentication.getVersion());
            return this.copyAuthenticationAttributes(response.getActivationId(), response.getUserId(), response.getApplicationId(), response.getApplicationRoles(), response.getActivationFlags(), authenticationContext, authentication.getVersion(), authentication.getHttpHeader(), activationContext);
        }
        catch (NumberFormatException ex) {
            logger.warn("Invalid timestamp format, error: {}", (Object)ex.getMessage());
            logger.debug("Error details", (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            logger.warn("Token validation failed, error: {}", (Object)ex.getMessage());
            logger.debug("Error details", (Throwable)ex);
            return null;
        }
    }

    private PowerAuthApiAuthenticationImpl copyAuthenticationAttributes(String activationId, String userId, String applicationId, List<String> applicationRoles, List<String> activationFlags, AuthenticationContext authenticationContext, String version, PowerAuthHttpHeader httpHeader, PowerAuthActivation activationContext) {
        PowerAuthApiAuthenticationImpl apiAuthentication = new PowerAuthApiAuthenticationImpl();
        apiAuthentication.setActivationId(activationId);
        apiAuthentication.setUserId(userId);
        apiAuthentication.setApplicationId(applicationId);
        apiAuthentication.setApplicationRoles(applicationRoles);
        apiAuthentication.setActivationFlags(activationFlags);
        apiAuthentication.setAuthenticationContext(authenticationContext);
        apiAuthentication.setAuthenticated(true);
        apiAuthentication.setVersion(version);
        apiAuthentication.setHttpHeader(httpHeader);
        apiAuthentication.setActivationContext(activationContext);
        return apiAuthentication;
    }

    private PowerAuthActivationImpl copyActivationAttributes(String activationId, String userId, ActivationStatus activationStatus, String blockedReason, List<String> activationFlags, AuthenticationContext authenticationContext, String version) {
        PowerAuthActivationImpl activationContext = new PowerAuthActivationImpl();
        activationContext.setActivationId(activationId);
        activationContext.setUserId(userId);
        activationContext.setActivationStatus(activationStatus);
        activationContext.setBlockedReason(blockedReason);
        activationContext.setActivationFlags(activationFlags);
        activationContext.setAuthenticationContext(authenticationContext);
        activationContext.setVersion(version);
        return activationContext;
    }

    @Override
    public PowerAuthApiAuthentication validateRequestSignature(@Nonnull String httpMethod, @Nullable byte[] httpBody, @Nonnull String requestUriIdentifier, @Nonnull String httpAuthorizationHeader, @Nonnull List<PowerAuthSignatureTypes> allowedSignatureTypes, @Nullable Integer forcedSignatureVersion) throws PowerAuthAuthenticationException {
        PowerAuthApiAuthentication apiAuthentication = this.validateRequestSignatureWithActivationDetails(httpMethod, httpBody, requestUriIdentifier, httpAuthorizationHeader, allowedSignatureTypes, forcedSignatureVersion);
        if (!apiAuthentication.getAuthenticationContext().isValid()) {
            return null;
        }
        return apiAuthentication;
    }

    @Override
    @Nonnull
    public PowerAuthApiAuthentication validateRequestSignatureWithActivationDetails(@Nonnull String httpMethod, @Nullable byte[] httpBody, @Nonnull String requestUriIdentifier, @Nonnull String httpAuthorizationHeader, @Nonnull List<PowerAuthSignatureTypes> allowedSignatureTypes, @Nullable Integer forcedSignatureVersion) throws PowerAuthAuthenticationException {
        if (httpAuthorizationHeader.equals("undefined")) {
            logger.warn("Signature HTTP header is missing");
            throw new PowerAuthHeaderMissingException();
        }
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(httpAuthorizationHeader);
        try {
            PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            logger.warn("Signature HTTP header validation failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthSignatureInvalidException();
        }
        PowerAuthSignatureTypes expectedSignatureType = PowerAuthSignatureTypes.getEnumFromString((String)header.getSignatureType());
        if (expectedSignatureType == null || !allowedSignatureTypes.contains(expectedSignatureType)) {
            logger.warn("Invalid signature type: {}", (Object)expectedSignatureType);
            throw new PowerAuthSignatureTypeInvalidException();
        }
        PowerAuthSignatureAuthenticationImpl powerAuthAuthentication = new PowerAuthSignatureAuthenticationImpl();
        powerAuthAuthentication.setActivationId(header.getActivationId());
        powerAuthAuthentication.setApplicationKey(header.getApplicationKey());
        powerAuthAuthentication.setNonce(BaseEncoding.base64().decode((CharSequence)header.getNonce()));
        powerAuthAuthentication.setSignatureType(header.getSignatureType());
        powerAuthAuthentication.setSignature(header.getSignature());
        powerAuthAuthentication.setHttpMethod(httpMethod);
        powerAuthAuthentication.setRequestUri(requestUriIdentifier);
        powerAuthAuthentication.setData(httpBody);
        powerAuthAuthentication.setVersion(header.getVersion());
        powerAuthAuthentication.setHttpHeader((PowerAuthHttpHeader)header);
        powerAuthAuthentication.setForcedSignatureVersion(forcedSignatureVersion);
        PowerAuthApiAuthentication auth = (PowerAuthApiAuthentication)this.authenticate((Authentication)powerAuthAuthentication);
        if (auth == null) {
            logger.debug("Signature validation failed");
            throw new PowerAuthSignatureInvalidException();
        }
        return auth;
    }

    @Override
    @Nullable
    public PowerAuthApiAuthentication validateToken(@Nonnull String tokenHeader, @Nonnull List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        PowerAuthApiAuthentication apiAuthentication = this.validateTokenWithActivationDetails(tokenHeader, allowedSignatureTypes);
        if (!apiAuthentication.getAuthenticationContext().isValid()) {
            return null;
        }
        return apiAuthentication;
    }

    @Override
    @Nonnull
    public PowerAuthApiAuthentication validateTokenWithActivationDetails(@Nonnull String tokenHeader, @Nonnull List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        if (tokenHeader.equals("undefined")) {
            logger.warn("Token HTTP header is missing");
            throw new PowerAuthHeaderMissingException();
        }
        PowerAuthTokenHttpHeader header = new PowerAuthTokenHttpHeader().fromValue(tokenHeader);
        try {
            PowerAuthTokenHttpHeaderValidator.validate((PowerAuthTokenHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            logger.warn("Token validation failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthTokenInvalidException();
        }
        PowerAuthTokenAuthenticationImpl powerAuthTokenAuthentication = new PowerAuthTokenAuthenticationImpl();
        powerAuthTokenAuthentication.setTokenId(header.getTokenId());
        powerAuthTokenAuthentication.setTokenDigest(header.getTokenDigest());
        powerAuthTokenAuthentication.setNonce(header.getNonce());
        powerAuthTokenAuthentication.setTimestamp(header.getTimestamp());
        powerAuthTokenAuthentication.setVersion(header.getVersion());
        powerAuthTokenAuthentication.setHttpHeader((PowerAuthHttpHeader)header);
        PowerAuthApiAuthentication auth = (PowerAuthApiAuthentication)this.authenticate((Authentication)powerAuthTokenAuthentication);
        if (auth == null) {
            logger.debug("Invalid token value");
            throw new PowerAuthTokenInvalidException();
        }
        PowerAuthSignatureTypes expectedSignatureType = auth.getAuthenticationContext().getSignatureType();
        if (expectedSignatureType == null || !allowedSignatureTypes.contains(expectedSignatureType)) {
            logger.warn("Invalid signature type in token validation: {}", (Object)expectedSignatureType);
            throw new PowerAuthSignatureTypeInvalidException();
        }
        return auth;
    }
}

