/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesDecryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEnvelopeKey;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesScope;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthEncryptionHttpHeaderValidator;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.spring.encryption.EciesEncryptionContext;
import io.getlime.security.powerauth.rest.api.spring.encryption.PowerAuthEciesDecryptorParameters;
import io.getlime.security.powerauth.rest.api.spring.encryption.PowerAuthEciesEncryption;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.spring.model.PowerAuthRequestBody;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PowerAuthEncryptionProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthEncryptionProviderBase.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final EciesFactory eciesFactory = new EciesFactory();

    @Nonnull
    public abstract PowerAuthEciesDecryptorParameters getEciesDecryptorParameters(@Nullable String var1, @Nonnull String var2, @Nonnull String var3) throws PowerAuthEncryptionException;

    @Nonnull
    public PowerAuthEciesEncryption decryptRequest(@Nonnull HttpServletRequest request, @Nonnull Type requestType, @Nonnull EciesScope eciesScope) throws PowerAuthEncryptionException {
        if (!"POST".equals(request.getMethod())) {
            logger.warn("Invalid HTTP method: {}", (Object)request.getMethod());
            throw new PowerAuthEncryptionException();
        }
        EciesEncryptionContext encryptionContext = this.extractEciesEncryptionContext(request);
        PowerAuthEciesEncryption eciesEncryption = new PowerAuthEciesEncryption(encryptionContext);
        eciesEncryption.getContext().setEciesScope(eciesScope);
        try {
            PowerAuthEciesDecryptorParameters decryptorParameters;
            EciesEncryptedRequest eciesRequest;
            PowerAuthRequestBody requestBody = (PowerAuthRequestBody)request.getAttribute("X-PowerAuth-Request-Body");
            if (requestBody == null) {
                logger.warn("The X-PowerAuth-Request-Body request attribute is missing. Register the PowerAuthRequestFilter to fix this error.");
                throw new PowerAuthEncryptionException();
            }
            byte[] requestBodyBytes = requestBody.getRequestBytes();
            if (requestBodyBytes == null || requestBodyBytes.length == 0) {
                logger.warn("Invalid HTTP request");
                throw new PowerAuthEncryptionException();
            }
            try {
                eciesRequest = (EciesEncryptedRequest)this.objectMapper.readValue(requestBodyBytes, EciesEncryptedRequest.class);
            }
            catch (IOException ex) {
                logger.warn("Request deserialization failed, error: {}", (Object)ex.getMessage());
                logger.debug(ex.getMessage(), (Throwable)ex);
                throw new PowerAuthEncryptionException();
            }
            if (eciesRequest == null) {
                logger.warn("Deserialization of request body bytes resulted in null value.");
                throw new PowerAuthEncryptionException();
            }
            String ephemeralPublicKey = eciesRequest.getEphemeralPublicKey();
            String encryptedData = eciesRequest.getEncryptedData();
            String mac = eciesRequest.getMac();
            String nonce = eciesRequest.getNonce();
            if (ephemeralPublicKey == null || encryptedData == null || mac == null) {
                logger.warn("Invalid ECIES request data");
                throw new PowerAuthEncryptionException();
            }
            if (nonce == null && !"3.0".equals(encryptionContext.getVersion())) {
                logger.warn("Missing nonce in ECIES request data");
                throw new PowerAuthEncryptionException();
            }
            byte[] ephemeralPublicKeyBytes = BaseEncoding.base64().decode((CharSequence)ephemeralPublicKey);
            byte[] encryptedDataBytes = BaseEncoding.base64().decode((CharSequence)encryptedData);
            byte[] macBytes = BaseEncoding.base64().decode((CharSequence)mac);
            byte[] nonceBytes = nonce != null ? BaseEncoding.base64().decode((CharSequence)nonce) : null;
            String applicationKey = eciesEncryption.getContext().getApplicationKey();
            switch (eciesScope) {
                case ACTIVATION_SCOPE: {
                    String activationId = eciesEncryption.getContext().getActivationId();
                    if (activationId == null) {
                        logger.warn("Activation ID is required in ECIES activation scope");
                        throw new PowerAuthEncryptionException();
                    }
                    decryptorParameters = this.getEciesDecryptorParameters(activationId, applicationKey, ephemeralPublicKey);
                    break;
                }
                case APPLICATION_SCOPE: {
                    decryptorParameters = this.getEciesDecryptorParameters(null, applicationKey, ephemeralPublicKey);
                    break;
                }
                default: {
                    logger.warn("Unsupported ECIES scope: {}", (Object)eciesScope);
                    throw new PowerAuthEncryptionException();
                }
            }
            byte[] secretKey = BaseEncoding.base64().decode((CharSequence)decryptorParameters.getSecretKey());
            EciesEnvelopeKey envelopeKey = new EciesEnvelopeKey(secretKey, ephemeralPublicKeyBytes);
            byte[] sharedInfo2 = BaseEncoding.base64().decode((CharSequence)decryptorParameters.getSharedInfo2());
            EciesDecryptor eciesDecryptor = this.eciesFactory.getEciesDecryptor(envelopeKey, sharedInfo2);
            eciesEncryption.setEciesDecryptor(eciesDecryptor);
            EciesCryptogram cryptogram = new EciesCryptogram(ephemeralPublicKeyBytes, macBytes, encryptedDataBytes, nonceBytes);
            byte[] decryptedData = eciesDecryptor.decryptRequest(cryptogram);
            eciesEncryption.setEncryptedRequest(encryptedDataBytes);
            eciesEncryption.setDecryptedRequest(decryptedData);
            if (decryptedData.length != 0) {
                eciesEncryption.setRequestObject(this.deserializeRequestData(decryptedData, requestType));
            }
            request.setAttribute("X-PowerAuth-Encryption-Object", (Object)eciesEncryption);
        }
        catch (Exception ex) {
            logger.warn("Request decryption failed, error: " + ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthEncryptionException();
        }
        return eciesEncryption;
    }

    @Nullable
    public EciesEncryptedResponse encryptResponse(@Nonnull Object responseObject, @Nonnull PowerAuthEciesEncryption eciesEncryption) {
        try {
            byte[] responseData = this.serializeResponseData(responseObject);
            EciesCryptogram cryptogram = eciesEncryption.getEciesDecryptor().encryptResponse(responseData);
            String encryptedDataBase64 = BaseEncoding.base64().encode(cryptogram.getEncryptedData());
            String macBase64 = BaseEncoding.base64().encode(cryptogram.getMac());
            return new EciesEncryptedResponse(encryptedDataBase64, macBase64);
        }
        catch (Exception ex) {
            logger.debug("Response encryption failed, error: " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private Object deserializeRequestData(byte[] requestData, Type requestType) throws IOException {
        if (requestType.equals(byte[].class)) {
            return requestData;
        }
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        JavaType requestJavaType = typeFactory.constructType(requestType);
        return this.objectMapper.readValue(requestData, requestJavaType);
    }

    private byte[] serializeResponseData(Object responseObject) throws JsonProcessingException {
        if (responseObject.getClass().equals(byte[].class)) {
            return (byte[])responseObject;
        }
        return this.objectMapper.writeValueAsBytes(responseObject);
    }

    private EciesEncryptionContext extractEciesEncryptionContext(HttpServletRequest request) throws PowerAuthEncryptionException {
        String encryptionHttpHeader = request.getHeader("X-PowerAuth-Encryption");
        String signatureHttpHeader = request.getHeader("X-PowerAuth-Authorization");
        if (encryptionHttpHeader == null && signatureHttpHeader == null) {
            logger.warn("Neither signature nor encryption HTTP header is present");
            throw new PowerAuthEncryptionException();
        }
        if (signatureHttpHeader != null) {
            PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHttpHeader);
            try {
                PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
            }
            catch (InvalidPowerAuthHttpHeaderException ex) {
                logger.warn("Signature HTTP header validation failed, error: {}", (Object)ex.getMessage());
                logger.debug(ex.getMessage(), (Throwable)ex);
                throw new PowerAuthEncryptionException();
            }
            String applicationKey = header.getApplicationKey();
            String activationId = header.getActivationId();
            String version = header.getVersion();
            return new EciesEncryptionContext(applicationKey, activationId, version, (PowerAuthHttpHeader)header);
        }
        PowerAuthEncryptionHttpHeader header = new PowerAuthEncryptionHttpHeader().fromValue(encryptionHttpHeader);
        try {
            PowerAuthEncryptionHttpHeaderValidator.validate((PowerAuthEncryptionHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            logger.warn("Encryption validation failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthEncryptionException();
        }
        String applicationKey = header.getApplicationKey();
        String activationId = header.getActivationId();
        String version = header.getVersion();
        return new EciesEncryptionContext(applicationKey, activationId, version, (PowerAuthHttpHeader)header);
    }
}

