/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.rest.api.security.annotation;

import io.getlime.rest.api.security.annotation.PowerAuth;
import io.getlime.rest.api.security.authentication.PowerAuthApiAuthentication;
import io.getlime.rest.api.security.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.lib.enums.PowerAuthSignatureTypes;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class PowerAuthAnnotationInterceptor
extends HandlerInterceptorAdapter {
    private PowerAuthAuthenticationProvider authenticationProvider;

    @Autowired
    public void setAuthenticationProvider(PowerAuthAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        PowerAuthApiAuthentication authentication;
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        PowerAuth powerAuthAnnotation = (PowerAuth)handlerMethod.getMethodAnnotation(PowerAuth.class);
        if (powerAuthAnnotation != null && (authentication = (PowerAuthApiAuthentication)this.authenticationProvider.validateRequestSignature(request, powerAuthAnnotation.resourceId(), request.getHeader("X-PowerAuth-Authorization"), new ArrayList<PowerAuthSignatureTypes>(Arrays.asList(powerAuthAnnotation.signatureType())))) != null) {
            request.setAttribute("X-PowerAuth-Authentication-Object", (Object)authentication);
        }
        return super.preHandle(request, response, handler);
    }
}

