/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.exception;

import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.model.base.PowerAuthApiResponse;
import io.getlime.security.powerauth.rest.api.model.entity.ErrorModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
@Order(value=-100)
public class PowerAuthExceptionHandler {
    public static final int PRECEDENCE = -100;

    @ExceptionHandler(value={PowerAuthAuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public PowerAuthApiResponse<ErrorModel> handleUnauthorizedException(Exception ex) {
        PowerAuthAuthenticationException paex = (PowerAuthAuthenticationException)((Object)ex);
        Logger.getLogger(PowerAuthExceptionHandler.class.getName()).log(Level.SEVERE, paex.getMessage(), paex);
        ErrorModel error = new ErrorModel(paex.getDefaultCode(), paex.getMessage());
        return new PowerAuthApiResponse("ERROR", (Object)error);
    }

    @ExceptionHandler(value={PowerAuthActivationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public PowerAuthApiResponse<ErrorModel> handleActivationException(Exception ex) {
        PowerAuthActivationException paex = (PowerAuthActivationException)ex;
        Logger.getLogger(PowerAuthExceptionHandler.class.getName()).log(Level.SEVERE, paex.getMessage(), (Throwable)paex);
        ErrorModel error = new ErrorModel(paex.getDefaultCode(), paex.getMessage());
        return new PowerAuthApiResponse("ERROR", (Object)error);
    }

    @ExceptionHandler(value={PowerAuthSecureVaultException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public PowerAuthApiResponse<ErrorModel> handleSecureVaultException(Exception ex) {
        PowerAuthSecureVaultException paex = (PowerAuthSecureVaultException)ex;
        Logger.getLogger(PowerAuthExceptionHandler.class.getName()).log(Level.SEVERE, paex.getMessage(), (Throwable)paex);
        ErrorModel error = new ErrorModel(paex.getDefaultCode(), paex.getMessage());
        return new PowerAuthApiResponse("ERROR", (Object)error);
    }
}

