/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.annotation;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuth;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthAuthenticationProvider;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class PowerAuthAnnotationInterceptor
extends HandlerInterceptorAdapter {
    private PowerAuthAuthenticationProvider authenticationProvider;

    @Autowired
    public void setAuthenticationProvider(PowerAuthAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        PowerAuth powerAuthAnnotation = (PowerAuth)handlerMethod.getMethodAnnotation(PowerAuth.class);
        if (powerAuthAnnotation != null) {
            try {
                PowerAuthApiAuthentication authentication = this.authenticationProvider.validateRequestSignature(request, powerAuthAnnotation.resourceId(), request.getHeader("X-PowerAuth-Authorization"), new ArrayList<PowerAuthSignatureTypes>(Arrays.asList(powerAuthAnnotation.signatureType())));
                if (authentication != null) {
                    request.setAttribute("X-PowerAuth-Authentication-Object", (Object)authentication);
                }
            }
            catch (PowerAuthAuthenticationException ex) {
                request.setAttribute("X-PowerAuth-Authentication-Object", null);
            }
        }
        return super.preHandle(request, response, handler);
    }
}

