/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.powerauth.soap.GetActivationStatusResponse;
import io.getlime.powerauth.soap.PrepareActivationResponse;
import io.getlime.powerauth.soap.RemoveActivationResponse;
import io.getlime.security.powerauth.rest.api.base.application.PowerAuthApplicationConfiguration;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.model.request.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.ActivationCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.ActivationRemoveResponse;
import io.getlime.security.powerauth.rest.api.model.response.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pa/activation"})
public class ActivationController {
    private PowerAuthServiceClient powerAuthClient;
    private PowerAuthAuthenticationProvider authenticationProvider;
    private PowerAuthApplicationConfiguration applicationConfiguration;

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @Autowired
    public void setAuthenticationProvider(PowerAuthAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    @Autowired
    public void setApplicationConfiguration(PowerAuthApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    @ResponseBody
    public ObjectResponse<ActivationCreateResponse> createActivation(@RequestBody ObjectRequest<ActivationCreateRequest> request) throws PowerAuthActivationException {
        try {
            String activationIDShort = ((ActivationCreateRequest)request.getRequestObject()).getActivationIdShort();
            String activationNonce = ((ActivationCreateRequest)request.getRequestObject()).getActivationNonce();
            String cDevicePublicKey = ((ActivationCreateRequest)request.getRequestObject()).getEncryptedDevicePublicKey();
            String activationName = ((ActivationCreateRequest)request.getRequestObject()).getActivationName();
            String extras = ((ActivationCreateRequest)request.getRequestObject()).getExtras();
            String applicationKey = ((ActivationCreateRequest)request.getRequestObject()).getApplicationKey();
            String applicationSignature = ((ActivationCreateRequest)request.getRequestObject()).getApplicationSignature();
            String clientEphemeralKey = ((ActivationCreateRequest)request.getRequestObject()).getEphemeralPublicKey();
            PrepareActivationResponse soapResponse = this.powerAuthClient.prepareActivation(activationIDShort, activationName, activationNonce, clientEphemeralKey, cDevicePublicKey, extras, applicationKey, applicationSignature);
            ActivationCreateResponse response = new ActivationCreateResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setActivationNonce(soapResponse.getActivationNonce());
            response.setEncryptedServerPublicKey(soapResponse.getEncryptedServerPublicKey());
            response.setEncryptedServerPublicKeySignature(soapResponse.getEncryptedServerPublicKeySignature());
            response.setEphemeralPublicKey(soapResponse.getEphemeralPublicKey());
            return new ObjectResponse((Object)response);
        }
        catch (Exception ex) {
            throw new PowerAuthActivationException();
        }
    }

    @RequestMapping(value={"status"}, method={RequestMethod.POST})
    @ResponseBody
    public ObjectResponse<ActivationStatusResponse> getActivationStatus(@RequestBody ObjectRequest<ActivationStatusRequest> request) throws PowerAuthActivationException {
        try {
            String activationId = ((ActivationStatusRequest)request.getRequestObject()).getActivationId();
            GetActivationStatusResponse soapResponse = this.powerAuthClient.getActivationStatus(activationId);
            ActivationStatusResponse response = new ActivationStatusResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setEncryptedStatusBlob(soapResponse.getEncryptedStatusBlob());
            if (this.applicationConfiguration != null) {
                response.setCustomObject(this.applicationConfiguration.statusServiceCustomObject());
            }
            return new ObjectResponse((Object)response);
        }
        catch (Exception ex) {
            throw new PowerAuthActivationException();
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.POST})
    @ResponseBody
    public ObjectResponse<ActivationRemoveResponse> removeActivation(@RequestHeader(value="X-PowerAuth-Authorization") String signatureHeader) throws PowerAuthActivationException, PowerAuthAuthenticationException {
        try {
            PowerAuthApiAuthentication apiAuthentication = this.authenticationProvider.validateRequestSignature("POST", null, "/pa/activation/remove", signatureHeader);
            if (apiAuthentication != null && apiAuthentication.getActivationId() != null) {
                RemoveActivationResponse soapResponse = this.powerAuthClient.removeActivation(apiAuthentication.getActivationId());
                ActivationRemoveResponse response = new ActivationRemoveResponse();
                response.setActivationId(soapResponse.getActivationId());
                return new ObjectResponse((Object)response);
            }
            throw new PowerAuthAuthenticationException("USER_NOT_AUTHENTICATED");
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PowerAuthActivationException();
        }
    }
}

