/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller;

import com.google.common.io.BaseEncoding;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthHttpHeader;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.model.response.VaultUnlockResponse;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pa/vault"})
public class SecureVaultController {
    private PowerAuthServiceClient powerAuthClient;

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @RequestMapping(value={"unlock"}, method={RequestMethod.POST})
    @ResponseBody
    public ObjectResponse<VaultUnlockResponse> unlockVault(@RequestHeader(value="X-PowerAuth-Authorization", defaultValue="unknown") String signatureHeader) throws PowerAuthAuthenticationException, PowerAuthSecureVaultException {
        try {
            Map map = PowerAuthHttpHeader.parsePowerAuthSignatureHTTPHeader((String)signatureHeader);
            String activationId = (String)map.get("pa_activation_id");
            String applicationId = (String)map.get("pa_application_key");
            String signature = (String)map.get("pa_signature");
            String signatureType = (String)map.get("pa_signature_type");
            String nonce = (String)map.get("pa_nonce");
            String data = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/vault/unlock", (byte[])BaseEncoding.base64().decode((CharSequence)nonce), null);
            io.getlime.powerauth.soap.VaultUnlockResponse soapResponse = this.powerAuthClient.unlockVault(activationId, applicationId, data, signature, signatureType);
            if (!soapResponse.isSignatureValid()) {
                throw new PowerAuthAuthenticationException();
            }
            VaultUnlockResponse response = new VaultUnlockResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setEncryptedVaultEncryptionKey(soapResponse.getEncryptedVaultEncryptionKey());
            return new ObjectResponse((Object)response);
        }
        catch (Exception ex) {
            if (PowerAuthAuthenticationException.class.equals(ex.getClass())) {
                throw ex;
            }
            throw new PowerAuthSecureVaultException();
        }
    }
}

