/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.provider;

import com.google.common.io.BaseEncoding;
import io.getlime.powerauth.soap.VerifySignatureRequest;
import io.getlime.powerauth.soap.VerifySignatureResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthHttpHeader;
import io.getlime.security.powerauth.rest.api.base.application.PowerAuthApplicationConfiguration;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.provider.PowerAuthAuthenticationProviderBase;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthApiAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthAuthenticationImpl;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class PowerAuthAuthenticationProvider
extends PowerAuthAuthenticationProviderBase
implements AuthenticationProvider {
    private PowerAuthServiceClient powerAuthClient;
    private PowerAuthApplicationConfiguration applicationConfiguration;

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @Autowired(required=false)
    public void setApplicationConfiguration(PowerAuthApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        PowerAuthAuthenticationImpl powerAuthAuthentication = (PowerAuthAuthenticationImpl)authentication;
        VerifySignatureRequest soapRequest = new VerifySignatureRequest();
        soapRequest.setActivationId(powerAuthAuthentication.getActivationId());
        soapRequest.setApplicationKey(powerAuthAuthentication.getApplicationKey());
        soapRequest.setSignature(powerAuthAuthentication.getSignature());
        soapRequest.setSignatureType(powerAuthAuthentication.getSignatureType());
        soapRequest.setData(PowerAuthHttpBody.getSignatureBaseString((String)powerAuthAuthentication.getHttpMethod(), (String)powerAuthAuthentication.getRequestUri(), (byte[])powerAuthAuthentication.getNonce(), (byte[])powerAuthAuthentication.getData()));
        VerifySignatureResponse soapResponse = this.powerAuthClient.verifySignature(soapRequest);
        if (soapResponse.isSignatureValid()) {
            PowerAuthApiAuthenticationImpl apiAuthentication = new PowerAuthApiAuthenticationImpl();
            apiAuthentication.setActivationId(soapResponse.getActivationId());
            apiAuthentication.setUserId(soapResponse.getUserId());
            apiAuthentication.setAuthenticated(true);
            return apiAuthentication;
        }
        return null;
    }

    public boolean supports(Class<?> authentication) {
        return authentication == PowerAuthAuthenticationImpl.class;
    }

    public PowerAuthApiAuthentication validateRequestSignature(String httpMethod, byte[] httpBody, String requestUriIdentifier, String httpAuthorizationHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        boolean isApplicationAllowed;
        if (httpAuthorizationHeader == null || httpAuthorizationHeader.equals("undefined")) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_INVALID_EMPTY");
        }
        Map httpHeaderInfo = PowerAuthHttpHeader.parsePowerAuthSignatureHTTPHeader((String)httpAuthorizationHeader);
        if (httpHeaderInfo == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_INVALID_EMPTY");
        }
        String activationId = (String)httpHeaderInfo.get("pa_activation_id");
        if (activationId == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_ACTIVATION_ID_EMPTY");
        }
        String nonce = (String)httpHeaderInfo.get("pa_nonce");
        if (nonce == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_NONCE_EMPTY");
        }
        String signatureType = (String)httpHeaderInfo.get("pa_signature_type");
        if (signatureType == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_TYPE_EMPTY");
        }
        String signature = (String)httpHeaderInfo.get("pa_signature");
        if (signature == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_EMPTY");
        }
        String applicationId = (String)httpHeaderInfo.get("pa_application_key");
        if (applicationId == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_APPLICATION_EMPTY");
        }
        if (this.applicationConfiguration != null && !(isApplicationAllowed = this.applicationConfiguration.isAllowedApplicationKey(applicationId))) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_INVALID_APPLICATION_ID");
        }
        PowerAuthSignatureTypes expectedSignatureType = PowerAuthSignatureTypes.getEnumFromString((String)signatureType);
        if (!allowedSignatureTypes.contains(expectedSignatureType)) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_TYPE_INVALID");
        }
        PowerAuthAuthenticationImpl powerAuthAuthentication = new PowerAuthAuthenticationImpl();
        powerAuthAuthentication.setActivationId(activationId);
        powerAuthAuthentication.setApplicationKey(applicationId);
        powerAuthAuthentication.setNonce(BaseEncoding.base64().decode((CharSequence)nonce));
        powerAuthAuthentication.setSignatureType(signatureType);
        powerAuthAuthentication.setSignature(signature);
        powerAuthAuthentication.setHttpMethod(httpMethod);
        powerAuthAuthentication.setRequestUri(requestUriIdentifier);
        powerAuthAuthentication.setData(httpBody);
        PowerAuthApiAuthentication auth = (PowerAuthApiAuthentication)this.authenticate((Authentication)powerAuthAuthentication);
        if (auth == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_INVALID_VALUE");
        }
        return auth;
    }
}

