/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller;

import com.google.common.io.BaseEncoding;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.powerauth.soap.SignatureType;
import io.getlime.powerauth.soap.VaultUnlockResponse;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.model.request.VaultUnlockRequest;
import io.getlime.security.powerauth.rest.api.spring.converter.SignatureTypeConverter;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pa/vault"})
public class SecureVaultController {
    private PowerAuthServiceClient powerAuthClient;

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @RequestMapping(value={"unlock"}, method={RequestMethod.POST})
    @ResponseBody
    public ObjectResponse<io.getlime.security.powerauth.rest.api.model.response.VaultUnlockResponse> unlockVault(@RequestHeader(value="X-PowerAuth-Authorization", defaultValue="unknown") String signatureHeader, @RequestBody(required=false) ObjectRequest<VaultUnlockRequest> request, HttpServletRequest httpServletRequest) throws PowerAuthAuthenticationException, PowerAuthSecureVaultException {
        try {
            byte[] requestBodyBytes;
            PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHeader);
            try {
                PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
            }
            catch (InvalidPowerAuthHttpHeaderException e) {
                throw new PowerAuthAuthenticationException(e.getMessage());
            }
            SignatureTypeConverter converter = new SignatureTypeConverter();
            String activationId = header.getActivationId();
            String applicationId = header.getApplicationKey();
            String signature = header.getSignature();
            SignatureType signatureType = converter.convertFrom(header.getSignatureType());
            String nonce = header.getNonce();
            String reason = null;
            if ("2.0".equals(header.getVersion())) {
                requestBodyBytes = null;
            } else {
                String requestBodyString;
                VaultUnlockRequest vaultUnlockRequest;
                if (request != null && (vaultUnlockRequest = (VaultUnlockRequest)request.getRequestObject()) != null && vaultUnlockRequest.getReason() != null) {
                    reason = vaultUnlockRequest.getReason();
                }
                requestBodyBytes = (requestBodyString = (String)httpServletRequest.getAttribute("X-PowerAuth-Request-Body")) == null ? null : BaseEncoding.base64().decode((CharSequence)requestBodyString);
            }
            String data = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/vault/unlock", (byte[])BaseEncoding.base64().decode((CharSequence)nonce), requestBodyBytes);
            VaultUnlockResponse soapResponse = this.powerAuthClient.unlockVault(activationId, applicationId, data, signature, signatureType, reason);
            if (!soapResponse.isSignatureValid()) {
                throw new PowerAuthAuthenticationException();
            }
            io.getlime.security.powerauth.rest.api.model.response.VaultUnlockResponse response = new io.getlime.security.powerauth.rest.api.model.response.VaultUnlockResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setEncryptedVaultEncryptionKey(soapResponse.getEncryptedVaultEncryptionKey());
            return new ObjectResponse((Object)response);
        }
        catch (Exception ex) {
            if (PowerAuthAuthenticationException.class.equals(ex.getClass())) {
                throw ex;
            }
            throw new PowerAuthSecureVaultException();
        }
    }
}

