/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.powerauth.soap.CreateTokenResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.model.request.TokenCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.TokenRemoveRequest;
import io.getlime.security.powerauth.rest.api.model.response.TokenCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.TokenRemoveResponse;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuth;
import io.getlime.security.powerauth.rest.api.spring.converter.SignatureTypeConverter;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"pa/token"})
public class TokenController {
    private PowerAuthServiceClient powerAuthClient;

    @Autowired
    public TokenController(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    @PowerAuth(resourceId="/pa/token/create", signatureType={PowerAuthSignatureTypes.POSSESSION, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY})
    @ResponseBody
    public ObjectResponse<TokenCreateResponse> createToken(@RequestBody ObjectRequest<TokenCreateRequest> request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            if (authentication != null && authentication.getActivationId() != null) {
                String activationId = authentication.getActivationId();
                PowerAuthSignatureTypes signatureFactors = authentication.getSignatureFactors();
                TokenCreateRequest requestObject = (TokenCreateRequest)request.getRequestObject();
                String ephemeralPublicKey = requestObject.getEphemeralPublicKey();
                SignatureTypeConverter converter = new SignatureTypeConverter();
                CreateTokenResponse token = this.powerAuthClient.createToken(activationId, ephemeralPublicKey, converter.convertFrom(signatureFactors));
                TokenCreateResponse responseObject = new TokenCreateResponse();
                responseObject.setMac(token.getMac());
                responseObject.setEncryptedData(token.getEncryptedData());
                return new ObjectResponse((Object)responseObject);
            }
            throw new PowerAuthAuthenticationException();
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.POST})
    @PowerAuth(resourceId="/pa/token/remove", signatureType={PowerAuthSignatureTypes.POSSESSION, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY})
    @ResponseBody
    public ObjectResponse<TokenRemoveResponse> removeToken(@RequestBody ObjectRequest<TokenRemoveRequest> request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            if (authentication != null && authentication.getActivationId() != null) {
                String activationId = authentication.getActivationId();
                TokenRemoveRequest requestObject = (TokenRemoveRequest)request.getRequestObject();
                String tokenId = requestObject.getTokenId();
                this.powerAuthClient.removeToken(tokenId, activationId);
                TokenRemoveResponse responseObject = new TokenRemoveResponse();
                responseObject.setTokenId(requestObject.getTokenId());
                return new ObjectResponse((Object)responseObject);
            }
            throw new PowerAuthAuthenticationException();
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
    }
}

