/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.annotation;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuth;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuthToken;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthAuthenticationProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class PowerAuthAnnotationInterceptor
extends HandlerInterceptorAdapter {
    private PowerAuthAuthenticationProvider authenticationProvider;

    @Autowired
    public void setAuthenticationProvider(PowerAuthAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            PowerAuthApiAuthentication authentication;
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            PowerAuth powerAuthSignatureAnnotation = (PowerAuth)handlerMethod.getMethodAnnotation(PowerAuth.class);
            PowerAuthToken powerAuthTokenAnnotation = (PowerAuthToken)handlerMethod.getMethodAnnotation(PowerAuthToken.class);
            if (powerAuthSignatureAnnotation != null && powerAuthTokenAnnotation != null) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "You cannot use both @PowerAuth and @PowerAuthToken on same handler method. We are removing both.");
                powerAuthSignatureAnnotation = null;
                powerAuthTokenAnnotation = null;
            }
            if (powerAuthSignatureAnnotation != null) {
                try {
                    authentication = this.authenticationProvider.validateRequestSignature(request, powerAuthSignatureAnnotation.resourceId(), request.getHeader("X-PowerAuth-Authorization"), new ArrayList<PowerAuthSignatureTypes>(Arrays.asList(powerAuthSignatureAnnotation.signatureType())));
                    request.setAttribute("X-PowerAuth-Authentication-Object", (Object)authentication);
                }
                catch (PowerAuthAuthenticationException ex) {
                    request.setAttribute("X-PowerAuth-Authentication-Object", null);
                }
            }
            if (powerAuthTokenAnnotation != null) {
                try {
                    authentication = this.authenticationProvider.validateToken(request.getHeader("X-PowerAuth-Token"), new ArrayList<PowerAuthSignatureTypes>(Arrays.asList(powerAuthTokenAnnotation.signatureType())));
                    request.setAttribute("X-PowerAuth-Authentication-Object", (Object)authentication);
                }
                catch (PowerAuthAuthenticationException ex) {
                    request.setAttribute("X-PowerAuth-Authentication-Object", null);
                }
            }
        }
        return super.preHandle(request, response, handler);
    }
}

